/*
 * Decompiled with CFR 0.152.
 */
package techdude.Class2C.Guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import techdude.Class2C.Systems.Joel;
import techdude.Class2C.Systems.Sean;
import techdude.Class2C.Systems.Tate;

public class AWS_Gun
extends Sean {
    public static final int WAVE_FUNCTION_GUESS = 0;
    public static final int WAVE_FUNCTION_GF_STAT = 1;
    public static final int NUM_GF_BUCKET = 31;
    public static final int NUM_DIST_BUCKET = 5;
    public static final int NUM_VEL_BUCKET = 5;
    public static double[] buckets = new double[31];
    double bestgf;

    public int WavePrintCode() {
        return 2;
    }

    public void update(Joel.RoboTrack shooter, Joel.RoboTrack target) {
    }

    public Vector StatsForWave(Tate.Record wave, double bulletPower) {
        Joel.Point me = wave.origin;
        Joel.RoboTrack enemy = wave.enemylocRef;
        Vector<Tate.Record.Stats> v = new Vector<Tate.Record.Stats>();
        double maxescapeangle = Math.asin(8.0 / Joel.bulletVelocity(bulletPower));
        double angleofenemy = me.absoluteAngleTo(enemy);
        int direction = Joel.sign(enemy.heading - angleofenemy);
        double angle_gfpos1 = angleofenemy + maxescapeangle * (double)direction;
        double angle_gfneg1 = angleofenemy - maxescapeangle * (double)direction;
        double angle_gfdiff2 = angle_gfneg1 - angle_gfpos1;
        double angle_gfdiff1 = angle_gfdiff2 / (double)2;
        double i = -1.0;
        while (i < 1.0) {
            double currgfangle = angleofenemy + angle_gfdiff1 * i;
            v.add(new Tate.Record.Stats(currgfangle, this, 1, i));
            i += 0.06451612903225806;
        }
        double currgfangle = this.getFiringAngle(me, enemy, bulletPower);
        v.add(new Tate.Record.Stats(currgfangle, this, 0, 0.0));
        return v;
    }

    public void WaveResult(Tate.Record wave, Tate.Record.Stats stat, boolean hit) {
        switch (stat.function) {
            case 0: {
                this.HitFrequencyToggle(hit);
                break;
            }
            case 1: {
                int gf_bucket = (int)((stat.parameter + 1.0) / (double)2 * 31.0);
                if (hit) {
                    int n = gf_bucket;
                    buckets[n] = buckets[n] + 0.01;
                    break;
                }
                int n = gf_bucket;
                buckets[n] = buckets[n] * 0.99;
                break;
            }
        }
    }

    public double getFiringAngle(Joel.Point me, Joel.RoboTrack enemy, double bulletPower) {
        int dist_bucket = this.DistaceBucket(enemy.distance(me));
        int vel_bucket = (int)((enemy.velocity / 8.0 + 1.0) / (double)2 * (double)5);
        double bestprob = 1.0E7;
        this.bestgf = 0.0;
        int i = 0;
        while (i < 31) {
            double prob = this.getGFProb(i, vel_bucket, dist_bucket);
            if (prob < bestprob) {
                bestprob = prob;
                this.bestgf = (double)i * (double)2 / 31.0 - 1.0;
            }
            ++i;
        }
        double maxescapeangle = Math.asin(8.0 / Joel.bulletVelocity(bulletPower));
        double angleofenemy = me.absoluteAngleTo(enemy);
        int direction = Joel.sign(enemy.heading - angleofenemy);
        double angle_gfpos1 = angleofenemy + maxescapeangle * (double)direction;
        double angle_gfneg1 = angleofenemy - maxescapeangle * (double)direction;
        double angle_gfdiff2 = angle_gfneg1 - angle_gfpos1;
        double angle_gfdiff1 = angle_gfdiff2 / (double)2;
        double currgfangle = angleofenemy + angle_gfdiff1 * this.bestgf;
        return currgfangle;
    }

    public double getGFProb(int gf, int vel, int dist) {
        return buckets[gf];
    }

    public int DistaceBucket(double dist) {
        double MAX_DISTANCE = 900.0;
        return (int)(dist / (MAX_DISTANCE / (double)5));
    }

    public void onPaint(Graphics2D g, int j) {
        super.onPaint(g, j);
        g.setColor(Color.WHITE);
        g.drawString("Anti_WaveSurfing Worst GF: " + this.bestgf, (int)this.battlefield.width / 2, 5 + j * 15);
    }

    public AWS_Gun(Rectangle2D.Double r) {
        super(r, new Color(255, 255, 100), "Anti-Wave Surfing", 0.0f, 0);
    }
}

