/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.FloatingTadpole;
import florent.Wave;
import florent.WaveCommand;

public class WaveCommandGunWeighted
extends WaveCommand {
    private double weight;
    private double[] bin2;
    private double[] bin3;

    public WaveCommandGunWeighted(double weight, double[] bin, double[] bin2, double[] bin3) {
        this.bin = bin;
        this.bin2 = bin2;
        this.bin3 = bin3;
        this.weight = weight;
    }

    public void doOnArrival(Wave wave) {
        int i = FloatingTadpole.toGF(wave.getLowGf(), this.bin);
        while (i <= FloatingTadpole.toGF(wave.getHighGf(), this.bin)) {
            int n = i;
            this.bin[n] = this.bin[n] + this.weight;
            this.bin[0] = this.bin[0] + 1.0;
            int n2 = i;
            this.bin2[n2] = this.bin2[n2] + this.weight;
            this.bin2[0] = this.bin2[0] + 1.0;
            int n3 = i++;
            this.bin3[n3] = this.bin3[n3] + this.weight;
            this.bin3[0] = this.bin3[0] + 1.0;
        }
    }

    public int getBestIndex(double distance) {
        double[] fastest = this.bin;
        double[] factors = this.bin2;
        double[] slow = this.bin3;
        int GF_ZERO = (fastest.length - 1) / 2;
        int GF_ONE = fastest.length - 1;
        int idx = GF_ZERO;
        double val = 0.0;
        double best = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            val = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(GF_ONE, gf + halfWidth)) {
                if ((val += 1.0 * factors[i] / Math.max(1.0, factors[0]) + 1.0 * slow[i] / Math.max(1.0, slow[0]) + 0.0 * (1.0 * fastest[i]) / Math.max(1.0, fastest[0]) / 10.0) > best) {
                    idx = i;
                    best = val;
                }
                ++i;
            }
            --gf;
        }
        return idx;
    }
}

