/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.BattleField;
import florent.Context;
import florent.FloatingTadpole;
import florent.PUtils;
import florent.Wave;
import florent.WaveCommandAdaptativeGun;
import florent.WaveCommandGun;
import florent.WaveCommandGunWeighted;
import florent.jUtil;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;

public class WaveManagerGun {
    protected static final int GF0 = 12;
    protected static final int GF1 = 24;
    private static final int WALL = 4;
    private static final int WALL_FAST = 3;
    private static final double WALL_INDEX_WIDTH = 5.5;
    private static final int MOVE = 5;
    private static final int MOVE_FAST = 3;
    private static final int BFT = 5;
    private static final int BFT_FAST = 3;
    private static final int ACCEL = 3;
    private static final int LATVEL = 5;
    private static final int LATVEL_FAST = 3;
    private static final int PM_SIG = 5;
    private static final int PM_SIG_FAST = 3;
    private static final int DIST = 6;
    private static final int DIST_FAST = 3;
    private static final int POWER = 5;
    private static double weight = 2.5;
    private static double virtualWeight = 0.0;
    private static double[] fastestFactors2 = new double[25];
    private static double[][][][][][][] factors2 = new double[4][6][5][5][5][5][25];
    private static double[][][][][][][] fastFactors2 = new double[3][3][5][3][3][5][25];
    protected static double[][][][][][] factors = new double[3][3][3][6][6][25];
    protected static double[][][][] fastFactors = new double[3][6][6][25];
    protected static double[][][][][][] adaptativeFactors = new double[3][3][3][6][6][25];
    protected static double[][][][] fastAdaptativeFactors = new double[3][6][6][25];
    protected static double[][][][][] fastAdaptativeTimedFactors = new double[3][6][6][4][25];
    protected static double[][][][][][][] timedFactors = new double[3][3][3][6][6][4][25];
    protected double[] cumulDistance = new double[1500];
    protected int cumulIndex;
    protected BattleField BF;
    protected double lastVChangeTime;
    protected Context target;
    protected double lastLateralVelocity;
    protected double lateralVelocity;
    protected double distance;
    protected double bearingDirection;
    protected double absoluteBearing;
    protected Point2D.Double enemyLocation;
    protected double lastVelocity;
    protected double velocity;
    protected Point2D.Double myLocation;
    protected double time;
    protected AdvancedRobot me;

    public WaveManagerGun(Context target, AdvancedRobot me) {
        this.target = target;
        this.BF = new BattleField(me);
        this.me = me;
    }

    public void init() {
    }

    public void synch() {
        if (this.time == this.target.getTime()) {
            return;
        }
        this.time = this.target.getTime();
        this.lastLateralVelocity = this.lateralVelocity;
        this.lateralVelocity = this.target.getLateralVelocity();
        this.distance = this.target.getDistance();
        this.bearingDirection = this.target.getBearingDirection();
        this.absoluteBearing = this.target.getAbsoluteBearing();
        this.enemyLocation = this.target.getEnemyLocation();
        this.lastVelocity = this.target.getLastVelocity();
        this.velocity = this.target.getVelocity();
        this.myLocation = this.target.getMyLocation();
        Wave.synch();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int i = 0;
        while ((double)i < (double)e.getTime() - this.time) {
            this.cumulDistance[this.cumulIndex] = e.getVelocity() + (this.cumulIndex > 1 ? this.cumulDistance[this.cumulIndex - 1] : 0.0);
            ++this.cumulIndex;
            ++i;
        }
    }

    public void createWave(double power, boolean fired) {
        this.addWave(this.giveWave(power), fired);
    }

    public void addWave(Wave wave, boolean fired) {
        if (fired) {
            this.me.addCustomEvent((Condition)wave);
        } else {
            this.me.addCustomEvent((Condition)this.giveVirtualWave(wave.getBulletPower()));
        }
    }

    public Wave giveWave(double power) {
        int bestGF;
        this.synch();
        int velIndex = (int)(Math.abs(this.lateralVelocity) / 3.0);
        int accelIndex = (int)Math.round(this.lateralVelocity - this.lastLateralVelocity);
        int wallIndex = this.BF.contains(jUtil.projectMotion(this.enemyLocation, this.absoluteBearing + this.bearingDirection * Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(power)), this.distance)) ? 0 : (this.BF.contains(jUtil.projectMotion(this.enemyLocation, this.absoluteBearing + 0.5 * this.bearingDirection * Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(power)), this.distance)) ? 1 : 2);
        double d = this.lastVChangeTime;
        this.lastVChangeTime = d + 1.0;
        double moveTime = FloatingTadpole.bulletVelocity(power) * d / this.distance;
        int n = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (bestGF = moveTime < 1.0 ? 3 : 4));
        int powerIndex = power < 1.0 ? 0 : (power < 2.0 ? 1 : 2);
        int distanceIndex = Math.min(5, (int)this.distance / 140);
        int distanceIndexFast = Math.min(2, (int)this.distance / 230);
        if (Math.abs(Math.abs(this.velocity) - Math.abs(this.lastVelocity)) > 0.6) {
            this.lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(this.velocity - this.lastVelocity);
            velIndex = (int)(Math.abs(this.velocity) / 3.0);
        }
        if (accelIndex != 0) {
            accelIndex = accelIndex > 0 ? 1 : 2;
        }
        Wave wave = new Wave(this.myLocation, this.time, this.absoluteBearing, power, this.bearingDirection);
        wave.addCommand(new WaveCommandAdaptativeGun(fastAdaptativeFactors[powerIndex][distanceIndex][bestGF]));
        wave.addCommand(new WaveCommandAdaptativeGun(adaptativeFactors[wallIndex][accelIndex][velIndex][distanceIndex][bestGF]));
        wave.addCommand(new WaveCommandGun(fastFactors[powerIndex][distanceIndex][bestGF]));
        wave.addCommand(new WaveCommandGun(factors[wallIndex][accelIndex][velIndex][distanceIndex][bestGF]));
        wave.addCommand(new WaveCommandGunWeighted(weight, fastestFactors2, fastFactors2[this.getWallIndexFast(this.absoluteBearing, this.bearingDirection, this.distance, wave.getGunLocation())][distanceIndexFast][(int)(power / 0.65)][this.velIndexFast(this.lastLateralVelocity)][this.velIndexFast(this.lateralVelocity)][bestGF], factors2[this.getWallIndex(this.absoluteBearing, this.bearingDirection, this.distance, wave.getGunLocation())][distanceIndex][(int)(power / 0.65)][this.velIndex(this.lastLateralVelocity)][this.velIndex(this.lateralVelocity)][bestGF]));
        return wave;
    }

    public Wave giveVirtualWave(double power) {
        int bestGF;
        this.synch();
        double d = this.lastVChangeTime;
        this.lastVChangeTime = d + 1.0;
        double moveTime = FloatingTadpole.bulletVelocity(power) * d / this.distance;
        int n = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (bestGF = moveTime < 1.0 ? 3 : 4));
        if (Math.abs(Math.abs(this.velocity) - Math.abs(this.lastVelocity)) > 0.6) {
            this.lastVChangeTime = 0.0;
            bestGF = 0;
        }
        int distanceIndex = Math.min(5, (int)this.distance / 140);
        int distanceIndexFast = Math.min(2, (int)this.distance / 230);
        Wave wave = new Wave(this.myLocation, this.time, this.absoluteBearing, power, this.bearingDirection);
        wave.addCommand(new WaveCommandGunWeighted(virtualWeight, fastestFactors2, fastFactors2[this.getWallIndexFast(this.absoluteBearing, this.bearingDirection, this.distance, wave.getGunLocation())][distanceIndexFast][(int)(power / 0.65)][this.velIndexFast(this.velocity)][this.accelIndex(this.velocity - this.lastVelocity)][bestGF], factors2[this.getWallIndex(this.absoluteBearing, this.bearingDirection, this.distance, wave.getGunLocation())][distanceIndex][(int)(power / 0.65)][this.velIndex(this.velocity)][this.accelIndex(this.velocity - this.lastVelocity)][bestGF]));
        return wave;
    }

    public static int getGF0() {
        return 12;
    }

    private double moveTimeIndex(double power, double distance) {
        double moveTime = jUtil.bulletVelocity(power) * this.lastVChangeTime / distance;
        return moveTime;
    }

    private int indexMTimeFast(double mTime) {
        if (mTime < 0.1) {
            return 0;
        }
        if (mTime < 0.3) {
            return 1;
        }
        return 2;
    }

    private int indexMTime(double mTime) {
        if (mTime < 0.1) {
            return 0;
        }
        if (mTime < 0.2) {
            return 1;
        }
        if (mTime < 0.3) {
            return 2;
        }
        if (mTime < 1.0) {
            return 3;
        }
        return 4;
    }

    private int getWallIndex(double bearing, double bearingDirection, double distance, Point2D.Double gunLocation) {
        int wallIndex = 0;
        while (++wallIndex < 4 && this.BF.contains(PUtils.project(gunLocation, bearing + bearingDirection * ((double)wallIndex * 5.5 * 1.0), distance))) {
        }
        return --wallIndex;
    }

    private int getWallIndexFast(double bearing, double bearingDirection, double distance, Point2D.Double gunLocation) {
        int wallIndex = 0;
        while (++wallIndex < 3 && this.BF.contains(PUtils.project(gunLocation, bearing + bearingDirection * ((double)wallIndex * 5.5 * 1.0), distance))) {
        }
        return --wallIndex;
    }

    private int accelIndex(double accel) {
        if (accel < -0.5) {
            return 0;
        }
        if (accel < 0.5) {
            return 1;
        }
        return 2;
    }

    private int velIndexFast(double velocity) {
        if ((velocity = Math.abs(velocity)) > 6.0) {
            return 2;
        }
        if (velocity > 3.0) {
            return 1;
        }
        return 0;
    }

    private int velIndex(double velocity) {
        if ((velocity = Math.abs(velocity)) > 7.5) {
            return 4;
        }
        if (velocity > 5.0) {
            return 3;
        }
        if (velocity > 2.5) {
            return 2;
        }
        if (velocity > 0.0) {
            return 1;
        }
        return 0;
    }

    private int bftIndexFast(double bft) {
        if (bft > 40.0) {
            return 2;
        }
        if (bft > 15.0) {
            return 1;
        }
        return 0;
    }

    private int bftIndex(double bft) {
        if (bft > 50.0) {
            return 4;
        }
        if (bft > 35.0) {
            return 3;
        }
        if (bft > 20.0) {
            return 2;
        }
        if (bft > 10.0) {
            return 1;
        }
        return 0;
    }

    private int pmSignatureIndex() {
        if (this.cumulIndex < 15) {
            return 0;
        }
        return Math.min(4, Math.max((int)((this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 15] + 120.0) / 48.0) - 1, 0));
    }

    private int pmSignatureIndexFast() {
        if (this.cumulIndex < 15) {
            return 0;
        }
        return Math.min(2, Math.max((int)((this.cumulDistance[this.cumulIndex] - this.cumulDistance[this.cumulIndex - 15] + 120.0) / 80.0) - 1, 0));
    }
}

