/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.geom.Point2D;
import wcsv.mega.Utils;

public class Location {
    private double x;
    private double y;

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Location(Point2D.Double p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Location copy() {
        return new Location(this.x, this.y);
    }

    public double distance(Location otherLoc) {
        return Math.sqrt(Utils.sqr(this.x - otherLoc.x) + Utils.sqr(this.y - otherLoc.y));
    }

    public double distanceSq(Location otherLoc) {
        return Utils.sqr(this.x - otherLoc.x) + Utils.sqr(this.y - otherLoc.y);
    }

    public double absBearing(Location otherLoc) {
        return Utils.absAngle(Math.atan2(otherLoc.x - this.x, otherLoc.y - this.y));
    }

    public Location project(double angle, double distance) {
        return new Location(this.x + Math.sin(angle) * distance, this.y + Math.cos(angle) * distance);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

