/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode.base;

import de.erdega.robocode.base.AbstractConditionHandler;
import de.erdega.robocode.base.AnalyzedScannedRobotEvent;
import de.erdega.robocode.base.IChassis;
import de.erdega.robocode.base.IGun;
import de.erdega.robocode.base.IRadar;
import de.erdega.robocode.base.IRobotAddon;
import de.erdega.robocode.base.IRobotModule;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public abstract class AbstractRobot
extends AdvancedRobot
implements IRobotAddon {
    private static final int CHASSIS_INDEX = 0;
    private static final int GUN_INDEX = 1;
    private static final int RADAR_INDEX = 2;
    private final IRobotModule[] _modules = new IRobotModule[3];
    private List<AbstractConditionHandler> _conditionHandlers = new LinkedList<AbstractConditionHandler>();

    public final void run() {
        this.updateChassis(this.createChassis());
        this.updateGun(this.createGun());
        this.updateRadar(this.createRadar());
        this.init();
        while (true) {
            this.execute();
        }
    }

    protected void init() {
    }

    protected IRadar createRadar() {
        return null;
    }

    protected IGun createGun() {
        return null;
    }

    protected IChassis createChassis() {
        return null;
    }

    public final void onScannedRobot(ScannedRobotEvent event) {
        AnalyzedScannedRobotEvent analyzedEvent = new AnalyzedScannedRobotEvent(this, event);
        this.onScannedRobot(analyzedEvent);
    }

    public void onScannedRobot(AnalyzedScannedRobotEvent event) {
        IRobotModule[] iRobotModuleArray = this._modules;
        int n = this._modules.length;
        int n2 = 0;
        while (n2 < n) {
            IRobotModule module = iRobotModuleArray[n2];
            if (module != null) {
                module.handleScannedRobotEvent(event);
            }
            ++n2;
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        IRobotModule[] iRobotModuleArray = this._modules;
        int n = this._modules.length;
        int n2 = 0;
        while (n2 < n) {
            IRobotModule module = iRobotModuleArray[n2];
            if (module != null) {
                module.handleBulletHitEvent(event);
            }
            ++n2;
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        IRobotModule[] iRobotModuleArray = this._modules;
        int n = this._modules.length;
        int n2 = 0;
        while (n2 < n) {
            IRobotModule module = iRobotModuleArray[n2];
            if (module != null) {
                module.handleHitByBulletEvent(event);
            }
            ++n2;
        }
    }

    public void onPaint(Graphics2D g) {
        IRobotModule[] iRobotModuleArray = this._modules;
        int n = this._modules.length;
        int n2 = 0;
        while (n2 < n) {
            IRobotModule module = iRobotModuleArray[n2];
            if (module != null) {
                module.onPaint(g);
            }
            ++n2;
        }
    }

    public void addCustomEvent(AbstractConditionHandler handler) {
        this._conditionHandlers.add(handler);
        this.addCustomEvent(handler);
    }

    public AdvancedRobot getRobot() {
        return this;
    }

    public void updateChassis(IChassis chassis) {
        this._modules[0] = chassis;
        if (chassis != null) {
            chassis.init();
        }
    }

    public void updateGun(IGun gun) {
        this._modules[1] = gun;
        if (gun != null) {
            this.setAdjustGunForRobotTurn(gun.isIndependent());
            gun.init();
        }
    }

    public void updateRadar(IRadar radar) {
        this._modules[2] = radar;
        if (radar != null) {
            this.setAdjustRadarForGunTurn(radar.isIndependent());
            radar.init();
        }
    }
}

