/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.Footprint;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import robocode.AdvancedRobot;

public class RobotLogEntry
implements Footprint {
    long time;
    Coord position;
    Compass heading;
    double velocity;
    double acceleration;
    double energy;
    int others;
    Enemy target;

    public RobotLogEntry(RobotInformation ri, Footprint previousFp) {
        AdvancedRobot ar = ri.getAdvancedRobot();
        this.time = ar.getTime();
        this.position = ri.getPosition();
        this.heading = new Compass(ar.getHeading());
        this.velocity = ar.getVelocity();
        this.energy = ar.getEnergy();
        this.others = ar.getOthers();
        this.target = null;
        if (previousFp == null) {
            this.acceleration = 0.0;
        } else {
            double timeDiff = this.time - previousFp.getTime();
            double velocityDiff = this.velocity - previousFp.getVelocity();
            this.acceleration = velocityDiff / timeDiff;
        }
    }

    public String toString() {
        return this.toReport();
    }

    public String toReport() {
        return String.valueOf(this.time) + ":" + this.position + " heading " + this.heading + " @ " + (int)this.velocity + ", energy " + (int)this.energy + ", " + this.others + " remaining.";
    }

    public long getTime() {
        return this.time;
    }

    public Coord getPosition() {
        return this.position;
    }

    public Compass getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getOthers() {
        return this.others;
    }

    public Enemy getTarget() {
        return this.target;
    }

    public double getAcceleration() {
        return this.acceleration;
    }
}

