/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Heading;
import shrub.ShrubMath;

public class Location {
    public static final Location ZERO_ZERO = new Location(0.0, 0.0);
    private final double mX;
    private final double mY;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    private Location(double xPos, double yPos) {
        this.mX = xPos;
        this.mY = yPos;
    }

    public static Location valueOf(double xPos, double yPos) {
        Location newLocn = new Location(xPos, yPos);
        return newLocn;
    }

    public double GetX() {
        return this.mX;
    }

    public double GetY() {
        return this.mY;
    }

    public double DistanceTo(Location toLocn) {
        double answer = -1.0;
        double deltaX = toLocn.GetX() - this.mX;
        double deltaY = toLocn.GetY() - this.mY;
        double targetDist2 = deltaX * deltaX + deltaY * deltaY;
        answer = Math.sqrt(targetDist2);
        return answer;
    }

    public static Location valueOfRelative(Location sourceLocn, Heading heading, double distance) {
        double degAngle = 0.0;
        double xSense = 0.0;
        double ySense = 0.0;
        if (heading.Get() < 90.0) {
            degAngle = heading.Get();
            xSense = 1.0;
            ySense = 1.0;
        } else if (heading.Get() < 180.0) {
            degAngle = 180.0 - heading.Get();
            xSense = 1.0;
            ySense = -1.0;
        } else if (heading.Get() < 270.0) {
            degAngle = heading.Get() - 180.0;
            xSense = -1.0;
            ySense = -1.0;
        } else {
            degAngle = 360.0 - heading.Get();
            xSense = -1.0;
            ySense = 1.0;
        }
        double deltaX = distance * ShrubMath.Sin(degAngle) * xSense;
        double deltaY = distance * ShrubMath.Cos(degAngle) * ySense;
        double newX = sourceLocn.GetX() + deltaX;
        double newY = sourceLocn.GetY() + deltaY;
        Location answer = new Location(newX, newY);
        return answer;
    }

    public String toString() {
        String answer = new String();
        answer = answer.concat("[");
        answer = answer.concat(dp2.format(this.mX));
        answer = answer.concat(",");
        answer = answer.concat(dp2.format(this.mY));
        answer = answer.concat("]");
        return answer;
    }

    public void Print() {
        System.out.print("[" + dp2.format(this.mX) + "," + dp2.format(this.mY) + "]");
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

