/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Heading;
import shrub.Location;
import shrub.Phasor;
import shrub.RadarInstruction;
import shrub.RadarModeAPI;
import shrub.RadarModeTOH;
import shrub.RobotDataStore;

public class RadarModePTL
implements RadarModeAPI {
    private Location mTargetLocn = Location.ZERO_ZERO;
    private final Phasor mPhasor;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private final RadarModeTOH mRadarModeTOH;

    public RadarModePTL(double scanSpeed, double scanPastAngle, Phasor scanPhasor) {
        this.mPhasor = scanPhasor;
        this.mRadarModeTOH = new RadarModeTOH(scanSpeed, scanPastAngle);
    }

    public void SetTargetLocn(Location targetLocn) {
        this.mTargetLocn = targetLocn;
    }

    public RadarInstruction GenerateInstruction() {
        Location radarLocn = this.mDataStore.getMyLocn();
        long timeNow = this.mDataStore.getCurrentTime();
        this.mPhasor.SetTimeNow(timeNow);
        double phasedOffset = this.mPhasor.GetPhaseValue();
        Heading targetHdng = Heading.valueOfFromTo(radarLocn, this.mTargetLocn);
        Heading adjHdng = Heading.valueOfAdjust(targetHdng, phasedOffset);
        this.mRadarModeTOH.SetTargetHdng(adjHdng);
        RadarInstruction instruct = this.mRadarModeTOH.GenerateInstruction();
        return instruct;
    }

    public void Resynchronise() {
        long timeNow = this.mDataStore.getCurrentTime();
        this.mPhasor.SetTimeStarted(timeNow);
        this.mRadarModeTOH.Resynchronise();
    }
}

