/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import java.util.ArrayList;
import java.util.List;
import robocode.Bullet;
import xander.core.AbstractXanderRobot;
import xander.core.event.GunFiredEvent;
import xander.core.event.GunListener;
import xander.core.gun.Gun;
import xander.core.track.Snapshot;

public class GunController {
    private AbstractXanderRobot robot;
    private List<GunListener> gunListeners = new ArrayList<GunListener>();

    public void setRobot(AbstractXanderRobot robot) {
        this.robot = robot;
    }

    public void addGunListener(GunListener gunListener) {
        this.gunListeners.add(gunListener);
    }

    public Bullet setFireBullet(Gun gun, Snapshot mySnapshot, Snapshot opponentSnapshot, double power) {
        if (this.robot.getEnergy() > 0.0 && this.robot.getGunHeat() <= 0.0) {
            Bullet bullet = this.robot.setFireBullet(power);
            GunFiredEvent event = new GunFiredEvent(gun, this.robot.getGunHeading(), power, mySnapshot, opponentSnapshot);
            for (GunListener gunListener : this.gunListeners) {
                gunListener.gunFired(event);
            }
            return bullet;
        }
        return null;
    }

    public void setFireVirtualBullet(Gun gun, double aim, double power, Snapshot mySnapshot, Snapshot opponentSnapshot) {
        GunFiredEvent event = new GunFiredEvent(gun, aim, power, mySnapshot, opponentSnapshot);
        for (GunListener gunListener : this.gunListeners) {
            gunListener.virtualGunFired(event);
        }
    }

    public boolean isGunReadyToFire() {
        return this.robot.getGunHeat() <= 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 0.05;
    }

    public double getGunCoolingRate() {
        return this.robot.getGunCoolingRate();
    }

    public double getGunHeadingDegrees() {
        return this.robot.getGunHeading();
    }

    public double getGunHeadingRadians() {
        return this.robot.getGunHeadingRadians();
    }

    public double getPreciseTimeUntilReadyToFire() {
        return this.robot.getGunHeat() / this.robot.getGunCoolingRate();
    }

    public void setTurnGunLeftDegrees(double degrees) {
        this.robot.setTurnGunLeft(degrees);
    }

    public void setTurnGunLeftRadians(double radians) {
        this.robot.setTurnGunLeftRadians(radians);
    }

    public void setTurnGunRightDegrees(double degrees) {
        this.robot.setTurnGunRight(degrees);
    }

    public void setTurnGunRightRadians(double radians) {
        this.robot.setTurnGunRightRadians(radians);
    }
}

