/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.UniformWeightInitializer;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.compound.AbstractInternalCompound;
import dmonner.xlbp.compound.DiagonalWeightBank;
import dmonner.xlbp.compound.IndirectWeightBank;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.compound.WeightedCompound;
import dmonner.xlbp.connection.ConnectionType;
import dmonner.xlbp.layer.UpstreamLayer;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractWeightedCompound
extends AbstractInternalCompound
implements WeightedCompound {
    private static final long serialVersionUID = 1L;
    protected WeightInitializer win;
    protected WeightUpdaterType wut;
    protected WeightBank[] conn;
    private Boolean truncate;

    public AbstractWeightedCompound(AbstractWeightedCompound that, NetworkCopier copier) {
        super(that, copier);
        this.win = that.win;
        this.wut = that.wut;
        this.truncate = that.truncate;
        this.conn = new WeightBank[0];
        for (WeightBank bank : that.conn) {
            copier.addWeightBank(bank);
        }
    }

    public AbstractWeightedCompound(String name) {
        super(name);
        this.win = new UniformWeightInitializer();
        this.wut = WeightUpdaterType.basic();
        this.truncate = null;
        this.conn = new WeightBank[0];
    }

    @Override
    public void activateTest() {
        for (WeightBank bank : this.conn) {
            bank.activateTest();
        }
    }

    @Override
    public void activateTrain() {
        for (WeightBank bank : this.conn) {
            bank.activateTrain();
        }
    }

    @Override
    public void addUpstream(UpstreamComponent upstream, ConnectionType type) {
        if (type == ConnectionType.WEIGHTED) {
            this.addUpstreamWeights(upstream);
        } else if (type == ConnectionType.DIRECT) {
            this.addUpstream(upstream);
        } else if (type == ConnectionType.INDIRECT) {
            this.addUpstreamWeights(new IndirectWeightBank(upstream.getName() + "IndirectTo" + this.name, upstream.asUpstreamLayer(), this.in, this.win, this.wut));
        } else if (type == ConnectionType.DIAGONAL) {
            this.addUpstreamWeights(new DiagonalWeightBank(upstream.getName() + "DiagonalTo" + this.name, upstream.asUpstreamLayer(), this.in, this.win, this.wut));
        } else {
            throw new IllegalArgumentException("Unhandled ConnectionType: " + (Object)((Object)type));
        }
    }

    private void addUpstreamWeights(String incomingName, UpstreamLayer upstream) {
        this.addUpstreamWeights(new WeightBank(incomingName + "To" + this.name, upstream, this.in, this.win, this.wut));
    }

    @Override
    public void addUpstreamWeights(UpstreamComponent upstream) {
        this.addUpstreamWeights(upstream.getName(), upstream.asUpstreamLayer());
    }

    public void addUpstreamWeights(WeightBank bank) {
        bank.setWeightUpdaterType(this.wut);
        bank.setWeightInitializer(this.win);
        if (this.truncate != null) {
            bank.truncate(this.truncate);
        }
        int index = this.conn.length;
        this.conn = Arrays.copyOf(this.conn, this.conn.length + 1);
        this.conn[index] = bank;
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            for (WeightBank bank : this.conn) {
                bank.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        for (WeightBank bank : this.conn) {
            bank.clearActivations();
        }
    }

    @Override
    public void clearEligibilities() {
        for (WeightBank bank : this.conn) {
            bank.clearEligibilities();
        }
    }

    @Override
    public void clearResponsibilities() {
        for (WeightBank bank : this.conn) {
            bank.clearResponsibilities();
        }
    }

    @Override
    public abstract AbstractWeightedCompound copy(NetworkCopier var1);

    @Override
    public AbstractWeightedCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        AbstractWeightedCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof AbstractWeightedCompound) {
            AbstractWeightedCompound that = (AbstractWeightedCompound)comp;
            ArrayList<WeightBank> list = new ArrayList<WeightBank>(that.conn.length);
            for (WeightBank bank : that.conn) {
                if (!copier.copyExists(bank)) continue;
                list.add(copier.getCopyOf(bank));
            }
            this.conn = list.toArray(new WeightBank[list.size()]);
        }
    }

    @Override
    public WeightBank getUpstreamWeights() {
        return this.getUpstreamWeights(0);
    }

    @Override
    public WeightBank getUpstreamWeights(int index) {
        return this.conn[index];
    }

    @Override
    public int nUpstreamWeights() {
        return this.conn.length;
    }

    @Override
    public int nWeights() {
        int sum = 0;
        for (WeightBank bank : this.conn) {
            sum += bank.nWeights();
        }
        return sum;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        if (this.in == null) {
            throw new IllegalStateException("Missing input layer.");
        }
        for (WeightBank bank : this.conn) {
            bank.optimize();
        }
        return true;
    }

    @Override
    public void processBatch() {
        for (WeightBank bank : this.conn) {
            bank.processBatch();
        }
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
        this.win = win;
        for (WeightBank bank : this.conn) {
            bank.setWeightInitializer(win);
        }
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
        this.wut = wut;
        for (WeightBank bank : this.conn) {
            bank.setWeightUpdaterType(wut);
        }
    }

    public void truncate(boolean truncate) {
        this.truncate = truncate;
        for (WeightBank bank : this.conn) {
            bank.truncate(truncate);
        }
    }

    @Override
    public void unbuild() {
        super.unbuild();
        for (WeightBank bank : this.conn) {
            bank.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
        for (WeightBank bank : this.conn) {
            bank.updateEligibilities();
        }
    }

    @Override
    public void updateResponsibilities() {
        for (WeightBank bank : this.conn) {
            bank.updateResponsibilities();
        }
    }

    @Override
    public void updateWeights() {
        for (WeightBank bank : this.conn) {
            bank.updateWeights();
        }
    }
}

