/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile.gun;

import cbot.agile.CU;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pattern {
    private byte[] velocityList;
    private double[] headingDeltaList;
    private StringBuffer track;
    private int MAX_TRACK;
    private int MIN_TRACK_LENGTH;
    private int trackLength;
    private long lastTime;
    private long totMatchLength;
    private int totMatches;

    public void init(Object trackInfo) {
        if (trackInfo != null) {
            this.unpackTrack(trackInfo);
        }
    }

    public void log(long time, double headingDelta, double velocity, double velocityDelta) {
        long timeDiff = time - this.lastTime;
        this.lastTime = time;
        velocity = this.timeNormalizeValue(timeDiff, velocity, 8);
        headingDelta = this.timeNormalizeValue(timeDiff, headingDelta, 10);
        this.velocityList[this.trackLength] = (byte)velocity;
        this.headingDeltaList[this.trackLength] = headingDelta;
        ++this.trackLength;
        char currentSymbol = this.getSymbolFromValues(headingDelta, velocity);
        this.track.append(currentSymbol);
        if (this.trackLength > this.MAX_TRACK - 2) {
            this.makeRoomInTrack();
        }
    }

    public void logBreak() {
        this.velocityList[this.trackLength] = 0;
        this.headingDeltaList[this.trackLength] = 0.0;
        ++this.trackLength;
        this.track.append('\uc350');
    }

    public int _getMatch() {
        int index = 0;
        int tmpIndex = 0;
        int patternStart = this.trackLength;
        String pattern = "";
        int patternLength = 0;
        while (tmpIndex != -1 && tmpIndex < this.trackLength - patternLength - this.MIN_TRACK_LENGTH && patternStart > 0) {
            index = tmpIndex;
            pattern = this.track.substring(this.trackLength - (patternLength += 2));
            tmpIndex = this.track.indexOf(pattern);
            if (tmpIndex != -1) continue;
            pattern = this.track.substring(this.trackLength - --patternLength);
            tmpIndex = this.track.indexOf(pattern);
        }
        if (index != 0) {
            ++this.totMatches;
            this.totMatchLength += (long)patternLength;
        }
        return index + patternLength;
    }

    public int getMatch() {
        int index = 0;
        int tmpIndex = 0;
        int patternStart = this.trackLength;
        String pattern = "";
        int patternLength = 0;
        while (tmpIndex != -1 && tmpIndex < this.trackLength - patternLength - this.MIN_TRACK_LENGTH && patternStart > 0) {
            index = tmpIndex;
            pattern = this.track.substring(this.trackLength - ++patternLength);
            tmpIndex = this.track.indexOf(pattern);
        }
        if (index != 0) {
            ++this.totMatches;
            this.totMatchLength += (long)patternLength;
        }
        return index + patternLength;
    }

    public Object getTrackData() {
        return this.packageTrack();
    }

    public double getVelocity(int index) {
        return this.velocityList[index];
    }

    public double getHeadingDelta(int index) {
        return this.headingDeltaList[index];
    }

    public int size() {
        return this.trackLength;
    }

    public boolean ready() {
        boolean bl = false;
        if (this.trackLength > this.MIN_TRACK_LENGTH) {
            bl = true;
        }
        return bl;
    }

    public String getAvgPatternLength() {
        return CU.formatNumber((double)this.totMatchLength / (double)this.totMatches);
    }

    private final Object[] packageTrack() {
        int MAX_LENGTH = 5000;
        Object[] trackInfo = new Object[2];
        int NEEDED_LENGTH = Math.min(MAX_LENGTH, this.trackLength);
        int n = 0;
        if (this.trackLength > MAX_LENGTH) {
            n = this.trackLength - MAX_LENGTH;
        }
        int startPos = n;
        trackInfo[0] = new byte[NEEDED_LENGTH];
        System.arraycopy(this.velocityList, startPos, trackInfo[0], 0, NEEDED_LENGTH);
        double[] tmp2 = new double[NEEDED_LENGTH];
        System.arraycopy(this.headingDeltaList, startPos, tmp2, 0, NEEDED_LENGTH);
        byte[] newHeadingDeltaList = new byte[tmp2.length];
        int i = 0;
        while (i < newHeadingDeltaList.length) {
            newHeadingDeltaList[i] = (byte)(this.headingDeltaList[i] * 10.0);
            ++i;
        }
        trackInfo[1] = newHeadingDeltaList;
        return trackInfo;
    }

    private final void makeRoomInTrack() {
        int removLength = (int)((double)this.MAX_TRACK * 0.1);
        this.trackLength -= removLength;
        this.track.replace(0, removLength, "");
        byte[] tmpVelocity = new byte[this.MAX_TRACK];
        System.arraycopy(this.velocityList, removLength - 1, tmpVelocity, 0, this.trackLength);
        this.velocityList = tmpVelocity;
        double[] tmpHeadingDelta = new double[this.MAX_TRACK];
        System.arraycopy(this.headingDeltaList, removLength - 1, tmpHeadingDelta, 0, this.trackLength);
        this.headingDeltaList = tmpHeadingDelta;
    }

    private final char getSymbolFromValues(double headingDelta, double velocity) {
        int velocityValue = (int)(velocity + 8.0);
        int headingDeltaValue = (int)Math.floor(((int)Math.floor(headingDelta) + 10) / 2);
        int totValue = 11 * velocityValue + headingDeltaValue;
        return (char)totValue;
    }

    private final void unpackTrack(Object trackInfoObject) {
        Object[] trackInfo = (Object[])trackInfoObject;
        byte[] tmpVelocityList = (byte[])trackInfo[0];
        int i = 0;
        while (i < tmpVelocityList.length) {
            this.velocityList[i] = tmpVelocityList[i];
            ++i;
        }
        byte[] tmpHeadingDeltaList = (byte[])trackInfo[1];
        int i2 = 0;
        while (i2 < tmpHeadingDeltaList.length) {
            this.headingDeltaList[i2] = (double)tmpHeadingDeltaList[i2] / 10.0;
            ++i2;
        }
        i2 = 0;
        while (i2 < tmpVelocityList.length) {
            this.track.append(this.getSymbolFromValues(this.headingDeltaList[i2], this.velocityList[i2]));
            ++i2;
        }
        this.trackLength = this.track.length();
    }

    private final double timeNormalizeValue(long timeDiff, double value, int valueLimit) {
        value /= (double)timeDiff;
        value = Math.min(value, (double)valueLimit);
        value = Math.max(value, (double)(-valueLimit));
        return value;
    }

    private final /* synthetic */ void this() {
        this.MAX_TRACK = 50000;
        this.MIN_TRACK_LENGTH = 30;
        this.trackLength = 0;
        this.lastTime = 0L;
        this.totMatchLength = 0L;
        this.totMatches = 0;
    }

    public Pattern() {
        this.this();
        this.velocityList = new byte[this.MAX_TRACK];
        this.headingDeltaList = new double[this.MAX_TRACK];
        this.track = new StringBuffer();
    }
}

