/*
 * Decompiled with CFR 0.152.
 */
package wcsv;

import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import wcsv.Stampede_TargetData;

public class Stampede_Gun {
    private static ArrayList vBullets = new ArrayList();
    private static ArrayList tempBullets = new ArrayList();
    private static Ellipse2D.Double enemyBounds = new Ellipse2D.Double();
    private static final int NUM_OFFSETS = 21;
    private static final double[] offsets;
    public static int[][][][] hitRates_Linear;
    public static int[][][][] hitRates_Circular;

    public void resetLists() {
        vBullets.clear();
        tempBullets.clear();
    }

    public void fireBulletWave(Stampede_TargetData t, double x, double y, long time, double power, boolean real) {
        if (Math.abs(t.tr) > 0.1) {
            int i = 0;
            while (i < 21) {
                vBullets.add(new vBullet(t, x, y, time, power, i, real, true));
                ++i;
            }
        } else {
            int i = 0;
            while (i < 21) {
                vBullets.add(new vBullet(t, x, y, time, power, i, real, false));
                ++i;
            }
        }
    }

    public void testBullets(double xt, double yt, long time) {
        int i = vBullets.size() - 1;
        while (i >= 0) {
            vBullet b = (vBullet)vBullets.get(i);
            if (b.testFinish(xt, yt, time)) {
                this.processBullet(b, xt, yt, time);
            } else {
                tempBullets.add(b);
            }
            --i;
        }
        vBullets = (ArrayList)tempBullets.clone();
        tempBullets.clear();
    }

    public void processBullet(vBullet b, double xt, double yt, long time) {
        int lateral = (int)(b.target.lateralVelocity(b.target.speed) + 8.0) / 4;
        int advance = (int)(b.target.advancingVelocity(b.target.speed) + 8.0) / 4;
        int flightTime = (int)Math.min((double)3, b.target.distance / b.velocity / 20.0);
        if (b.circular) {
            int[] nArray = hitRates_Circular[lateral][advance][flightTime];
            int n = b.offsetIndex;
            nArray[n] = nArray[n] + (b.testHit(xt, yt, time) ? 1 : 0 - b.realBullet);
        } else {
            int[] nArray = hitRates_Linear[lateral][advance][flightTime];
            int n = b.offsetIndex;
            nArray[n] = nArray[n] + (b.testHit(xt, yt, time) ? 1 : 0 - b.realBullet);
        }
    }

    public double[] getBestOffset(Stampede_TargetData t, double firePower) {
        int max = 0;
        int maxc = 0;
        int lateral = (int)(t.lateralVelocity(t.speed) + 8.0) / 4;
        int advance = (int)(t.advancingVelocity(t.speed) + 8.0) / 4;
        int flightTime = (int)Math.min((double)3, t.distance / (20.0 - (double)3 * firePower) / 20.0);
        int i = 1;
        while (i < 21) {
            if (hitRates_Linear[lateral][advance][flightTime][i] > hitRates_Linear[lateral][advance][flightTime][max]) {
                max = i;
            }
            ++i;
        }
        i = 1;
        while (i < 21) {
            if (hitRates_Circular[lateral][advance][flightTime][i] > hitRates_Circular[lateral][advance][flightTime][maxc]) {
                maxc = i;
            }
            ++i;
        }
        if (Math.abs(t.tr) > 0.1 && maxc > max) {
            return new double[]{offsets[maxc], 1.0};
        }
        return new double[]{offsets[max], -1.0};
    }

    static {
        double[] dArray = new double[21];
        dArray[1] = -1.0;
        dArray[2] = -0.9;
        dArray[3] = -0.8;
        dArray[4] = -0.7;
        dArray[5] = -0.6;
        dArray[6] = -0.5;
        dArray[7] = -0.4;
        dArray[8] = -0.3;
        dArray[9] = -0.2;
        dArray[10] = -0.1;
        dArray[11] = 0.1;
        dArray[12] = 0.2;
        dArray[13] = 0.3;
        dArray[14] = 0.4;
        dArray[15] = 0.5;
        dArray[16] = 0.6;
        dArray[17] = 0.7;
        dArray[18] = 0.8;
        dArray[19] = 0.9;
        dArray[20] = 1.0;
        offsets = dArray;
        hitRates_Linear = new int[5][5][4][21];
        hitRates_Circular = new int[5][5][4][21];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class vBullet {
        public double x;
        public double y;
        private long fireTime;
        private double velocity;
        public Stampede_TargetData target;
        public int offsetIndex;
        public double angle;
        public boolean realBullet;
        public boolean circular;

        public double radius(long time) {
            return (double)(time - this.fireTime) * this.velocity;
        }

        public boolean testFinish(double xt, double yt, long time) {
            boolean bl = false;
            if (this.radius(time) >= Stampede_TargetData.calcDistance(this.x, this.y, xt, yt)) {
                bl = true;
            }
            return bl;
        }

        public boolean testHit(double xt, double yt, long time) {
            enemyBounds.setFrame(xt - 18.0, yt - 18.0, 36.0, 36.0);
            return enemyBounds.contains(Stampede_TargetData.calcX(this.x, this.angle, this.radius(time)), Stampede_TargetData.calcY(this.y, this.angle, this.radius(time)));
        }

        private final /* synthetic */ void this() {
            this.realBullet = false;
            this.circular = false;
        }

        public vBullet(Stampede_TargetData t, double x0, double y0, long time, double firePower, int speedOffsetIndex, boolean real, boolean circ) {
            this.this();
            this.target = t;
            this.x = x0;
            this.y = y0;
            this.fireTime = time;
            this.velocity = 20.0 - (double)3 * firePower;
            this.offsetIndex = speedOffsetIndex;
            this.realBullet = real;
            this.circular = circ;
            this.angle = !this.circular ? Stampede_TargetData.absbearing(this.x, this.y, this.target.calcNextX_Linear(8.0 * offsets[this.offsetIndex], this.target.calcTime(firePower), 1), this.target.calcNextY_Linear(8.0 * offsets[this.offsetIndex], this.target.calcTime(firePower), 1)) : Stampede_TargetData.absbearing(this.x, this.y, this.target.calcNextX_LinearCircular(8.0 * offsets[this.offsetIndex], this.target.calcTime(firePower), 1), this.target.calcNextY_LinearCircular(8.0 * offsets[this.offsetIndex], this.target.calcTime(firePower), 1));
        }
    }
}

