/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Enemy;
import bing2.EnemyTracker;
import bing2.Gun;
import bing2.MathUtils;
import bing2.MyRobot;
import bing2.WaveTracker;

public class GFGun
extends Gun {
    static double SHORT_RANGE = 100.0;
    Enemy en;
    EnemyTracker tracker;
    boolean aiming = false;
    static WaveTracker selfWaves = new WaveTracker(true);

    public GFGun(MyRobot myRobot) {
        super(myRobot);
        selfWaves.onRoundStart();
    }

    public void aim(EnemyTracker enemyTracker) {
        this.tracker = enemyTracker;
        this.en = enemyTracker.getLatestRecord();
        if (this.en == null) {
            return;
        }
        selfWaves.updateWaves(this.robot.getTime(), enemyTracker.latest.getPosition());
        if (this.robot.getEnergy() < 3.0 && this.en.getEnergy() > 10.0 || this.robot.getEnergy() < 1.0) {
            return;
        }
        if (this.robot.getGunHeat() > this.robot.getGunCoolingRate()) {
            this.aiming = false;
            double d = MathUtils.normalizeRadians(this.en.getBearing() - this.robot.getGunHeadingRadians());
            this.robot.setTurnGunRightRadians(d);
        } else {
            double d;
            double d2 = this.en.getDistance();
            double d3 = d = d2 > SHORT_RANGE ? 2.0 : 3.0;
            if (this.robot.getEnergy() < 3.0) {
                d = 0.1;
            }
            if (this.aiming && Math.abs(this.robot.getGunTurnRemainingRadians()) <= Math.asin(9.0 / d2)) {
                this.robot.setFireBullet(d);
                double d4 = Gun.getBulletVelocity(d);
                int n = this.en.getDirectionZ();
                Enemy enemy = this.en;
                while (n == 0 && enemy != null) {
                    Enemy enemy2 = enemyTracker.getRecordByTime(enemy.getTime() - 1L);
                    if (enemy2 != null) {
                        n = enemy2.getDirectionZ();
                    }
                    enemy = enemy2;
                }
                selfWaves.addWave(this.robot.getX(), this.robot.getY(), d4, this.robot.getTime(), this.en.getBearing(), n);
                this.aiming = false;
            } else {
                this.robot.setTurnGunRightRadians(this.estimateGunTurn(d));
                this.aiming = true;
            }
        }
    }

    private double estimateGunTurn(double d) {
        if (this.en.getEnergy() < 0.05 && this.en.getVelocity() == 0.0) {
            return MathUtils.normalizeRadians(this.en.getBearing() - this.robot.getGunHeadingRadians());
        }
        double[] dArray = GFGun.selfWaves.allStats[0].visitStat;
        int n = dArray.length / 2;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        double d2 = WaveTracker.convertBinIndexToRelativeBearing(d, n);
        double d3 = this.en.getBearing() + (double)MathUtils.sign(this.en.getDirection()) * d2;
        return MathUtils.normalizeRadians(d3 - this.robot.getGunHeadingRadians());
    }
}

