/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.util.CalculatedValue;

public class RollingAverage
implements CalculatedValue {
    private final double vw;
    private final double aw;
    private double ra;
    private double weightSum = 0.0;

    public RollingAverage(double d, double w) {
        this.aw = d;
        this.vw = w;
    }

    @Override
    public void add(double value) {
        this.weightSum += this.vw;
        this.ra = RollingAverage.crunch(value, this.vw, this.ra, Math.min(this.aw, this.weightSum));
    }

    private static double crunch(double v, double vw, double a, double aw) {
        return (a * (aw - vw) + v * vw) / aw;
    }

    @Override
    public double value() {
        return this.ra;
    }
}

