/*
 * Decompiled with CFR 0.152.
 */
package stordy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import stordy.ForcePoint;
import stordy.ForcePointRandom;
import stordy.TargetingData;
import stordy.Vec2d;
import stordy.VirtualBulletHandler;

public class StordyBot
extends AdvancedRobot {
    private Hashtable<String, TargetingData> enemyHashMap = new Hashtable();
    private ArrayList<String> knownRobots = new ArrayList();
    private ArrayList<ForcePointRandom> randomForces = new ArrayList();
    private TargetingData myTargetData;
    private boolean reverse = false;
    private static int bulletsHit;
    private static int bulletsMissed;
    private int scanCount = 0;
    private double startScanHeading;

    public void run() {
        TargetingData.setArenaSize(new Vec2d(this.getBattleFieldWidth(), this.getBattleFieldHeight()));
        this.myTargetData = new TargetingData(new Vec2d(this.getX(), this.getY()), 0.0, this.getHeadingRadians(), this.getTime());
        VirtualBulletHandler.getHandler().setup(this.myTargetData, this.enemyHashMap);
        double qbfw = this.getBattleFieldWidth() / 4.0;
        double qbfh = this.getBattleFieldHeight() / 4.0;
        this.randomForces.add(new ForcePointRandom(new Vec2d(qbfw, qbfh), 100.0));
        this.randomForces.add(new ForcePointRandom(new Vec2d(qbfw * 3.0, qbfh), 100.0));
        this.randomForces.add(new ForcePointRandom(new Vec2d(qbfw, qbfh * 3.0), 100.0));
        this.randomForces.add(new ForcePointRandom(new Vec2d(qbfw * 3.0, qbfh * 3.0), 100.0));
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        boolean reverseOneStepsAgo = false;
        boolean reverseTwoStepsAgo = false;
        ArrayList recentSpeeds = new ArrayList();
        while (true) {
            this.myTargetData.updateLastKnownData(new Vec2d(this.getX(), this.getY()), this.getVelocity(), this.getHeadingRadians(), this.getTime());
            VirtualBulletHandler.getHandler().update(this.getTime());
            reverseTwoStepsAgo = reverseOneStepsAgo;
            reverseOneStepsAgo = this.reverse;
            Vec2d tforce = this.getTotalForce();
            double moveHeading = Math.atan2(tforce.getX(), tforce.getY());
            double relTurn = this.reverse ? Utils.normalRelativeAngle((double)(moveHeading - this.getHeadingRadians() + Math.PI)) : Utils.normalRelativeAngle((double)(moveHeading - this.getHeadingRadians()));
            if (Math.abs(relTurn) > 1.5707963267948966) {
                boolean bl = this.reverse = !this.reverse;
            }
            if (this.reverse != reverseOneStepsAgo && this.reverse == reverseTwoStepsAgo) {
                this.turnRight(90.0);
                this.ahead(2.0);
                boolean bl = this.reverse = !this.reverse;
            }
            if (this.reverse) {
                this.setBack(100.0);
                this.setTurnRightRadians(-relTurn);
            } else {
                this.setAhead(100.0);
                this.setTurnRightRadians(relTurn);
            }
            if (this.enemyHashMap.size() > 0) {
                TargetingData td = null;
                for (TargetingData ttd : this.enemyHashMap.values()) {
                    if (td == null) {
                        td = ttd;
                        continue;
                    }
                    if (!(ttd.getDistance(this.getX(), this.getY()) < td.getDistance(this.getX(), this.getY()))) continue;
                    td = ttd;
                }
                if (td != null) {
                    double targetBearing = td.predictBearingRadians(new Vec2d(this.getX(), this.getY()), this.getTime(), 2.0);
                    double turnBearing = Utils.normalRelativeAngle((double)(this.getGunHeadingRadians() - targetBearing));
                    this.setTurnGunLeftRadians(turnBearing);
                    if (Math.abs(Utils.normalRelativeAngle((double)(this.getGunHeadingRadians() - targetBearing))) < 0.1) {
                        this.fire(2.0);
                        targetBearing = td.predictBearingRadians(new Vec2d(this.getX(), this.getY()), this.getTime(), 2.0);
                    }
                }
            }
            this.execute();
        }
    }

    private Vec2d getTotalForce() {
        Vec2d totalForce = new Vec2d(0.0, 0.0);
        Vec2d myPos = new Vec2d(this.getX(), this.getY());
        double lo = this.getX();
        double ro = this.getBattleFieldWidth() - this.getX();
        double bo = this.getY();
        double to = this.getBattleFieldHeight() - this.getY();
        double lf = 150.0 / (lo * lo);
        double rf = 150.0 / (ro * ro);
        double bf = 150.0 / (bo * bo);
        double tf = 150.0 / (to * to);
        totalForce = totalForce.add(new Vec2d(lf - rf, bf - tf));
        if (this.getOthers() > 1) {
            totalForce = totalForce.add(new ForcePoint(new Vec2d(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0), 200.0).getForceOnPoint(myPos));
        }
        for (TargetingData targetingData : this.enemyHashMap.values()) {
            ForcePoint fp = new ForcePoint(targetingData.getLastPosition(), 25.0);
            totalForce = totalForce.add(fp.getForceOnPoint(myPos));
        }
        for (ForcePoint forcePoint : VirtualBulletHandler.getHandler().getBulletForces(this.getTime())) {
            totalForce = totalForce.add(forcePoint.getForceOnPoint(myPos));
        }
        for (ForcePointRandom forcePointRandom : this.randomForces) {
            forcePointRandom.tick();
            totalForce = totalForce.add(forcePointRandom.getForceOnPoint(myPos));
        }
        return totalForce;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++bulletsHit;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++bulletsMissed;
    }

    public void onBattleEnded(BattleEndedEvent event) {
        System.out.println("Hit: " + bulletsHit + ", Missed: " + bulletsMissed);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double b = e.getBearingRadians() + super.getHeadingRadians();
        b = Utils.normalAbsoluteAngle((double)b);
        if (++this.scanCount >= this.getOthers()) {
            double turnArc = Utils.normalAbsoluteAngle((double)(b - this.startScanHeading));
            if (turnArc < Math.PI || turnArc > 5.969026041820607) {
                this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
            }
            this.startScanHeading = b;
            this.scanCount = 0;
        }
        double myx = this.getX();
        double myy = this.getY();
        while (b > Math.PI) {
            b -= Math.PI * 2;
        }
        double d = e.getDistance();
        double x = myx + Math.sin(b) * d;
        double y = myy + Math.cos(b) * d;
        if (this.enemyHashMap.containsKey(e.getName())) {
            this.enemyHashMap.get(e.getName()).updateLastKnownData(new Vec2d(x, y), e.getVelocity(), e.getHeadingRadians(), e.getEnergy(), this.getTime());
        } else {
            this.enemyHashMap.put(e.getName(), new TargetingData(new Vec2d(x, y), e.getVelocity(), e.getHeadingRadians(), e.getEnergy(), this.getTime(), e.getName()));
        }
        if (!this.knownRobots.contains(e.getName())) {
            this.knownRobots.add(e.getName());
        }
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        for (TargetingData td : this.enemyHashMap.values()) {
            Vec2d predictedPosition = td.getPredictedPosition(new Vec2d(this.getX(), this.getY()), td.deltaTime(this.getTime()), 2.0);
            g.setColor(Color.pink);
            g.drawLine((int)this.getX(), (int)this.getY(), (int)predictedPosition.getX(), (int)predictedPosition.getY());
            g.setColor(Color.green);
            g.drawOval((int)td.getLastPosition().getX() - 3, (int)td.getLastPosition().getY() - 3, 6, 6);
            g.setColor(Color.cyan);
            g.drawOval((int)predictedPosition.getX() - 3, (int)predictedPosition.getY() - 3, 6, 6);
            ForcePoint rForce = new ForcePoint(td.getLastPosition(), 25.0);
            rForce.drawForce(g);
            g.setColor(Color.red);
            VirtualBulletHandler.getHandler().drawBullets(g, this.getTime());
        }
        for (ForcePointRandom fp : this.randomForces) {
            fp.drawForce(g);
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.enemyHashMap.remove(event.getName());
        this.knownRobots.remove(event.getName());
    }

    public void onHitWall(HitWallEvent event) {
    }
}

