/*
 * Decompiled with CFR 0.152.
 */
package fullsail;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimbotNoPrediction
extends AdvancedRobot {
    int nScanCount;
    double dRadarTurn;
    byte moveDirection;
    CEnemy myEnemy;
    String szTarget;
    long lDeltaTime;

    public void run() {
        this.setBodyColor(new Color(138, 43, 226));
        this.setGunColor(Color.black);
        this.setRadarColor(Color.white);
        this.setScanColor(new Color(138, 43, 226));
        this.setBulletColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.szTarget = null;
        this.dRadarTurn = 10.0;
        this.myEnemy = new CEnemy();
        while (true) {
            this.Timbot_Wiggle();
            this.Timbot_Fire();
            if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 10.0 && this.szTarget != null) {
                this.setFire(this.myEnemy.dFirePower);
            }
            this.execute();
        }
    }

    void Timbot_Wiggle() {
        if (this.getTime() % 25L == 0L) {
            this.moveDirection = (byte)(this.moveDirection * -1);
            this.setAhead(250 * this.moveDirection);
        }
        if (this.myEnemy.dDistance > 400.0 + (200.0 - this.getEnergy() * (double)2)) {
            this.setTurnRight(this.myEnemy.dBearing);
            this.setAhead(this.myEnemy.dDistance - 210.0);
        } else {
            this.setTurnRight(this.myEnemy.dBearing + 90.0);
        }
        if (this.myEnemy.dDistance < 200.0) {
            this.moveDirection = this.myEnemy.dBearing > -90.0 && this.myEnemy.dBearing <= 90.0 ? (byte)-1 : (byte)1;
            this.setAhead(1000 * this.moveDirection);
        }
    }

    void Timbot_Fire() {
        double gunOffset = this.normalRelativeAngle(this.myEnemy.dBearing + (this.getHeading() - this.getGunHeading()));
        this.setTurnGunRight(gunOffset);
    }

    void Timbot_FireLinear() {
        this.out.println("SHOT: Linear");
        long time = this.getTime() + (long)((int)(this.myEnemy.dDistance / (20.0 - (double)3 * this.myEnemy.dFirePower)));
        double gunOffset = this.getGunHeadingRadians() - this.absoluteBearing(this.getX(), this.getY(), this.myEnemy.PredictLinearX(time), this.myEnemy.PredictLinearY(time));
        this.setTurnGunRightRadians(this.normalizeBearing(gunOffset));
    }

    void Timbot_FireCircular() {
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.szTarget == null) {
            this.szTarget = e.getName();
            this.out.println("Tracking " + this.szTarget + " because I saw him.");
        }
        if (!e.getName().equals(this.szTarget)) {
            return;
        }
        this.myEnemy.Update(e);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        if (this.szTarget != null && !this.szTarget.equals(event.getName())) {
            this.out.println("Tracking " + event.getName() + " cause he shot me.");
            this.szTarget = event.getName();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.szTarget != null && !this.szTarget.equals(e.getName())) {
            this.out.println("Tracking " + e.getName() + " cause he rammed me.");
            this.szTarget = e.getName();
        }
        double gunTurnAmt = this.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
        this.turnGunRight(gunTurnAmt);
        this.setFire(3);
        this.setAhead(1000 * this.moveDirection * -1);
        this.execute();
    }

    public void onWin(WinEvent e) {
        System.out.println("... and hear the lamentation of their women.");
    }

    public double normalAbsoluteAngle(double dAngle) {
        if (dAngle >= 0.0 && dAngle < 360.0) {
            return dAngle;
        }
        double dNewAngle = dAngle;
        while (dNewAngle < 0.0) {
            dNewAngle += 360.0;
        }
        while (dNewAngle >= 360.0) {
            dNewAngle -= 360.0;
        }
        return dNewAngle;
    }

    public double normalRelativeAngle(double dAngle) {
        if (dAngle > -180.0 && dAngle <= 180.0) {
            return dAngle;
        }
        double dNewAngle = dAngle;
        while (dNewAngle <= -180.0) {
            dNewAngle += 360.0;
        }
        while (dNewAngle > 180.0) {
            dNewAngle -= 360.0;
        }
        return dNewAngle;
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    private final /* synthetic */ void this() {
        this.nScanCount = 0;
        this.moveDirection = 1;
        this.lDeltaTime = 0L;
    }

    public TimbotNoPrediction() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CEnemy {
        public double dX = 0.0;
        public double dY = 0.0;
        public double dBearing = 0.0;
        public double dHeading = 0.0;
        public double dScannedTime = 0.0;
        public double dVelocity = 0.0;
        public double dDistance = 0.0;
        public double dFirePower = 0.0;

        double PredictLinearX(double dDT) {
            double dTrueDelta = dDT - this.dScannedTime;
            return this.dX + Math.sin(Math.toRadians(TimbotNoPrediction.this.getHeading())) * TimbotNoPrediction.this.getVelocity() * dTrueDelta;
        }

        double PredictLinearY(double dDT) {
            double dTrueDelta = dDT - this.dScannedTime;
            return this.dY + Math.cos(Math.toRadians(TimbotNoPrediction.this.getHeading())) * TimbotNoPrediction.this.getVelocity() * dTrueDelta;
        }

        void Update(ScannedRobotEvent e) {
            this.dScannedTime = TimbotNoPrediction.this.getTime();
            this.dDistance = e.getDistance();
            this.dBearing = e.getBearing();
            this.dHeading = e.getHeading();
            this.dVelocity = e.getVelocity();
            this.dFirePower = Math.max(800.0 / this.dDistance, TimbotNoPrediction.this.getEnergy() / 10.0);
            double absBearingDeg = TimbotNoPrediction.this.getHeading() + this.dHeading;
            if (absBearingDeg < 0.0) {
                absBearingDeg += 360.0;
            }
            this.dX = TimbotNoPrediction.this.getX() + Math.sin(Math.toRadians(absBearingDeg)) * this.dDistance;
            this.dY = TimbotNoPrediction.this.getY() + Math.cos(Math.toRadians(absBearingDeg)) * this.dDistance;
        }

        CEnemy() {
        }
    }
}

