/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pa3k.Aiming;
import pa3k.BulletTracking;
import pa3k.Cluster;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Rules;

public class MonteCarloAiming
extends Aiming {
    protected MonteCarlo monteCarlo;

    public MonteCarloAiming(AdvancedRobot advancedRobot, String string, boolean bl, MonteCarlo monteCarlo) {
        super(advancedRobot, string, bl);
        this.monteCarlo = monteCarlo;
    }

    public static double getRandomHitProbability(MonteCarlo monteCarlo, double d, Position position) {
        double d2;
        Position[] positionArray = monteCarlo.simulatePosition(d, position);
        List<Cluster> list = MonteCarloAiming.getClusters(positionArray);
        if (list.size() == 0) {
            return 0.0;
        }
        Iterator<Cluster> iterator = list.iterator();
        Cluster cluster = null;
        while (iterator.hasNext()) {
            Cluster cluster2 = iterator.next();
            if (cluster != null && cluster.getWeight() >= cluster2.getWeight()) continue;
            cluster = cluster2;
        }
        double d3 = 1.0;
        long l = monteCarlo.getSamples();
        if (l < 150L) {
            d3 = 0.1;
        }
        if (l < 80L) {
            d3 = 0.05;
        }
        if (l < 30L) {
            d3 = 0.0;
        }
        return (d2 = (double)cluster.getWeight() / (double)positionArray.length) > d3 ? d3 : d2;
    }

    public static List<Cluster> getClusters(Position[] positionArray) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>(5);
        for (Position position : positionArray) {
            boolean bl = false;
            for (Cluster cluster : arrayList) {
                if (!cluster.fits(position)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new Cluster(position));
        }
        return arrayList;
    }

    @Override
    public BulletTracking getBestAimingAngle(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        BulletTracking bulletTracking = new BulletTracking(d, position, opponent, tracking, l);
        Position[] positionArray = this.monteCarlo.simulatePosition(Rules.getBulletSpeed((double)d), position);
        for (Position object2 : positionArray) {
            Log.paintFilledCircle(3, object2, 9, new Color(0, 255, 0, 30), 0);
        }
        List<Cluster> list = MonteCarloAiming.getClusters(positionArray);
        Cluster object = (Cluster)list.get(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Cluster cluster = (Cluster)iterator.next();
            if (cluster.getWeight() <= object.getWeight()) continue;
            object = cluster;
        }
        bulletTracking.setFiringAngle(position.getDirectionTo(object.getPosition()));
        Log.paintFilledCircle(3, object.getPosition(), 9, new Color(0, 0, 255, 80), 0);
        return bulletTracking;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bulletTracking) {
        double[] dArray = new double[1];
        return dArray;
    }
}

