/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

class Range {
    double min;
    double max;

    public Range(double d) {
        this.min = d - 0.5;
        this.max = d + 0.5;
    }

    public Range(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public Range(long l) {
        if (l == 10000L) {
            this.min = 40.0;
            this.max = 10000.0;
        } else {
            this.min = (double)l - 0.5;
            this.max = (double)l + 0.5;
        }
    }

    public boolean test(double d) {
        return d >= this.min && d <= this.max;
    }

    public boolean isSpecialCaseOf(Range range) {
        if (this.min < range.min) {
            return false;
        }
        return !(this.max > range.max);
    }

    public double cmp(Range range) {
        double d = (range.max < this.max ? range.max : this.max) - (range.min > this.min ? range.min : this.min);
        if (d < 0.0) {
            return 1.0 / Math.abs(range.min - this.max);
        }
        if (d == 0.0) {
            return 1.0;
        }
        return 10.0 + (d / (this.max - this.min) + d / (range.max - range.min)) / 2.0;
    }

    public void generalizeWith(Range range) {
        this.min = this.min < range.min ? this.min : range.min;
        this.max = this.max > range.max ? this.max : range.max;
    }

    public String toString() {
        return "[" + this.min + "," + this.max + "]";
    }
}

