package asd.gun.nn1;
import java.util.ArrayList;
/**
 * MyClass - a class by (your name here)
 */
public class PatternTrainer
{
	//constaint
	double maxX, maxY;
	long maxTick;
	
	ArrayList/*<Point>*/ coordinate = new ArrayList/*<Point>*/();
	
	public PatternTrainer(double maxX, double maxY, long maxTick){
		this.maxX = maxX;
		this.maxY = maxY;
		this.maxTick = maxTick;
	}
	
	public int learnSize(){
		return coordinate.size()-1;
	}

	public double[] getInput(int index){
		double[] input = new double[4];
		Point a = (Point)coordinate.get(index);
		Point b = (Point)coordinate.get(index + 1);
		input[0] = a.getX()/* / maxX */;
		input[1] = a.getY()/* / maxY */;
		input[2] = a.getTick()/* / maxTick */;
		input[3] = b.getTick()/* / maxTick */;
		return input;
	}

	public double[] getInput(int index, long tick){
		double[] input = new double[4];
		Point a = (Point)coordinate.get(index);
		input[0] = a.getX()/* / maxX */;
		input[1] = a.getY()/* / maxY */;
		input[2] = a.getTick()/* / maxTick */;
		input[3] = tick/* / maxTick */;
		return input;
	}

	public double[] getOutput(int index){
		double[] output = new double[3];
		Point a = (Point)coordinate.get(index);
		Point b = (Point)coordinate.get(index + 1);
		output[0] = ( b.getX() - a.getX() ) / maxX;
		output[1] = ( b.getY() - a.getY() ) / maxY;
		return output;
	}

	public void add(double x, double y, long tick){
		coordinate.add( new Point(x, y, tick) );
	}

	public double getMaxX(){
		return maxX;
	}

	public double getMaxY(){
		return maxY;
	}

	public double getMaxTick(){
		return maxTick;
	}

	public String toResultString(double[] output, long tick){
		double x = ((Point)coordinate.get(learnSize())).getX();
		double y = ((Point)coordinate.get(learnSize())).getY();
		Point temp = new Point(output[0]*getMaxX() + x,output[1]*getMaxY() + y, tick);
		return temp.toString();
	}

	public double[] toResult(double[] output){
		double[] ris = new double[2];
		double x = ((Point)coordinate.get(learnSize())).getX();
		double y = ((Point)coordinate.get(learnSize())).getY();
		ris[0] = output[0]*getMaxX() + x;
		ris[1] = output[1]*getMaxY() + y;
		return ris;
	}
}
