package testantiswapgun;

import robocode.*;
//import java.awt.Color;
import java.util.ArrayList;
import java.awt.Graphics2D;
/**
 * AntiSwap - a robot by (your name here)
 */
public class AntiSwap extends AdvancedRobot
{

	double myFutureX = -1;
	double myFutureY = -1;
	static long bulletHit = 0;
	static long bulletMissed = 0;
	static long win = 0;
	static long death = 0;	
	ArrayList<Wave> virtualBullet = new ArrayList<Wave>();
	boolean canShot = false;
	double adjustedBearing;
	double headOnBearing;
	ScannedRobotEvent enemyScanned;
	double shotPower = 1;

	MovSim movementSimulator = new MovSim();
	
	double forPaintEnemyX = 0;
	double forPaintEnemyY = 0;
	
	/**
	 * run: AntiSwap's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		setAdjustGunForRobotTurn( true );
		setAdjustRadarForGunTurn( true );
		setAdjustRadarForRobotTurn( true );
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			look();
			move();
			shot();
			execute();
		}
	}
	
	private void look(){
		if (getRadarTurnRemainingRadians() == 0)
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	private void move(){
		setTurnRightRadians(5000);
		setAhead(500);
		if ( (getX() != myFutureX) || (getY() != myFutureY) ){
			System.out.println( getTime()+": Error estimating future position x:"+(getX()-myFutureX)+" y: "+(getY()-myFutureY) );
		}
		MovSimStat[] myFuturePosition = movementSimulator.futurePos(1, this);
		myFutureX = myFuturePosition[0].x;
		myFutureY = myFuturePosition[0].y;
	}

	private void scrivi(String cosa){
		System.out.println(getTime()+": "+cosa);
	}
	
	private void shot(){
	
		if ( (Math.abs(getGunTurnRemaining()) < 0.000000000000000000000000000000000000000000000000000000000000000000000001) && (canShot) ){
			Bullet fired = setFireBullet(shotPower);
			if (fired != null){
				System.out.println(getTime()+"shot");

				System.out.println( adjustedBearing+" "+ robocode.util.Utils.normalRelativeAngle(fired.getHeadingRadians())+" "+getGunHeadingRadians()+" "+headOnBearing );
				virtualBullet.add(new Wave(getX(), getY(), fired.getVelocity(), getTime(), adjustedBearing, headOnBearing, fired.getHeadingRadians()));
			}
			canShot = false;
		}
	

		if (enemyScanned != null){ //if target aquired
			int maxTurnForSetGun = 0;
			double myFutureX;
			double myFutureY;
			
			double enemyFutureX = getX() + enemyScanned.getDistance()*Math.sin(headOnBearing);
			double enemyFutureY = getY() + enemyScanned.getDistance()*Math.cos(headOnBearing);
			
			MovSimStat[] futurePosition;
			
			double angleToTurn;
			do{
				maxTurnForSetGun++;
				futurePosition = movementSimulator.futurePos(maxTurnForSetGun, this);
				myFutureX = futurePosition[maxTurnForSetGun-1].x;
				myFutureY = futurePosition[maxTurnForSetGun-1].y;
				//scrivi("my x at "+(getTime()+maxTurnForSetGun)+": "+myFutureX);
				//scrivi("my y at "+(getTime()+maxTurnForSetGun)+": "+myFutureY);
				
				futurePosition = movementSimulator.futurePos(maxTurnForSetGun, this, enemyScanned);
				enemyFutureX = futurePosition[maxTurnForSetGun-1].x;
				enemyFutureY = futurePosition[maxTurnForSetGun-1].y;
				//scrivi("enemy x at "+(getTime()+maxTurnForSetGun)+": "+enemyFutureX);
				//scrivi("enemy y at "+(getTime()+maxTurnForSetGun)+": "+enemyFutureY);
				
				double distance = java.awt.geom.Point2D.distance(myFutureX, myFutureY, enemyFutureX, enemyFutureY);
				int shotTravelTime = (int)Math.floor(distance/Rules.getBulletSpeed(shotPower));
				
				futurePosition = movementSimulator.futurePos((maxTurnForSetGun+shotTravelTime), this, enemyScanned);
				enemyFutureX = futurePosition[(maxTurnForSetGun+shotTravelTime)-1].x;
				enemyFutureY = futurePosition[(maxTurnForSetGun+shotTravelTime)-1].y;
				//scrivi("enemy x2 at "+(getTime()+maxTurnForSetGun)+": "+enemyFutureX);
				//scrivi("enemy y2 at "+(getTime()+maxTurnForSetGun)+": "+enemyFutureY);
				
				adjustedBearing = Math.atan2( enemyFutureX - myFutureX , enemyFutureY - myFutureY );
				angleToTurn = robocode.util.Utils.normalRelativeAngle( adjustedBearing - getGunHeadingRadians() );
				
				
			}while( (angleToTurn+getGunTurnRemaining()) >= (Rules.GUN_TURN_RATE_RADIANS*maxTurnForSetGun) );
			
			forPaintEnemyX =enemyFutureX;
			forPaintEnemyY =enemyFutureY;
			
			setTurnGunRightRadians( angleToTurn );
			
			canShot = true;
			
			enemyScanned = null;
			
			scrivi("final turn to wait: "+maxTurnForSetGun+" "+getGunTurnRemaining());
		}
		
		
		
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		
		enemyScanned = e;
		
		headOnBearing = absoluteBearing;
		
		double radarTurn = robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians());

		// Width of the bot, plus twice the arc it can move in a tick, limit it to the max turn
		double arcToScan = Math.min(Math.atan(36.0 / e.getDistance()), Math.PI/4.0);

		// We want to sent the radar even further in the direction it's moving
		radarTurn += (radarTurn < 0) ? -arcToScan : arcToScan;
  		setTurnRadarRightRadians(radarTurn);

	}
	
	public void onPaint(Graphics2D g){
		for (Wave temp:virtualBullet){
			temp.onPaint( g, getTime() );
		}
		double raggio = 20;
		g.drawOval( (int)(forPaintEnemyX-raggio), (int)(forPaintEnemyY-raggio), (int)(raggio*2), (int)(raggio*2) );
		raggio = 20;
		g.drawOval( (int)(myFutureX-raggio), (int)(myFutureY-raggio), (int)(raggio*2), (int)(raggio*2) );
	}
	
	public void onBulletHit(BulletHitEvent event){
		bulletHit++;
	}
	
	public void onBulletMissed(BulletMissedEvent event){
		bulletMissed++;
	}
	
	public void onDeath(DeathEvent event){
		death++;
		stampaFine();
	}
	
	private void stampaFine(){
		System.out.println("hit: "+bulletHit+" miss: "+bulletMissed+" %: "+((double)bulletMissed/(double)(bulletHit+bulletMissed))*100);
		System.out.println("win: "+win+" lost: "+death);
	}
	
	public void onWin(WinEvent event){
		win++;
		stampaFine();
	}
	
	public void onHitRobot(HitRobotEvent event){
		scrivi("hit robot");
	}
	
	public void onHitWall(HitWallEvent event){
		scrivi("hit wall");
	}
}
