/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.InternalLayer;
import dmonner.xlbp.layer.UpstreamLayer;

public abstract class AbstractInternalLayer
extends AbstractUpstreamLayer
implements InternalLayer {
    private static final long serialVersionUID = 1L;
    protected UpstreamLayer upstream = null;
    protected int nUpstream = 0;
    protected int myIndexInUpstream = -1;

    public AbstractInternalLayer(AbstractInternalLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public AbstractInternalLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void addUpstream(UpstreamComponent upstream) {
        if (this.upstream != null) {
            throw new IllegalStateException("Upstream layer for " + this.name + " already set!");
        }
        this.nUpstream = 1;
        this.upstream = upstream.asUpstreamLayer();
        this.connectUpstream();
        this.myIndexInUpstream = upstream.indexOfDownstream(this);
    }

    @Override
    public DownstreamLayer asDownstreamLayer() {
        return this;
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.myIndexInUpstream = this.upstream.indexOfDownstream(this);
            this.built = true;
        }
    }

    @Override
    public boolean connectedUpstream(UpstreamComponent upstream) {
        return this.upstream == upstream;
    }

    protected void connectUpstream() {
        if (!this.upstream.connectedDownstream(this)) {
            this.upstream.addDownstream(this);
        }
    }

    @Override
    public abstract AbstractInternalLayer copy(NetworkCopier var1);

    @Override
    public AbstractInternalLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof AbstractInternalLayer) {
            AbstractInternalLayer that = (AbstractInternalLayer)comp;
            this.upstream = copier.getCopyIfExists(that.upstream);
            this.nUpstream = that.nUpstream;
            this.myIndexInUpstream = that.myIndexInUpstream;
        }
    }

    protected void disconnectUpstream() {
        int index;
        if (this.upstream != null && (index = this.upstream.indexOfDownstream(this)) >= 0) {
            this.upstream.removeDownstream(index);
        }
    }

    @Override
    public int getIndexInUpstream() {
        return this.myIndexInUpstream;
    }

    @Override
    public int getIndexInUpstream(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Only " + this.nUpstream + " upstream layers available from " + this.name + "; cannot get layer " + index);
        }
        return this.myIndexInUpstream;
    }

    @Override
    public UpstreamComponent getUpstream() {
        return this.upstream;
    }

    @Override
    public UpstreamComponent getUpstream(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Only " + this.nUpstream + " upstream layers available from " + this.name + "; cannot get layer " + index);
        }
        return this.upstream;
    }

    @Override
    public int indexOfUpstream(UpstreamComponent upstream) {
        return this.upstream == upstream ? 0 : -1;
    }

    @Override
    public int nUpstream() {
        return this.nUpstream;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        if (this.upstream == null) {
            throw new IllegalStateException("No upstream layer set for " + this.name);
        }
        return true;
    }

    @Override
    public void removeUpstream(int index) {
        if (index >= this.nUpstream) {
            throw new IndexOutOfBoundsException("Only " + this.nUpstream + " upstream layers available from " + this.name + "; cannot remove layer " + index);
        }
        this.disconnectUpstream();
        this.upstream = null;
        this.nUpstream = 0;
    }

    @Override
    public void removeUpstream(UpstreamComponent upstream) {
        if (this.upstream != upstream) {
            throw new IllegalArgumentException(upstream.getName() + " is not present in upstream layers of " + this.name);
        }
        this.disconnectUpstream();
        this.upstream = null;
        this.nUpstream = 0;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showConnectivity()) {
            sb.appendln("Upstream: " + this.upstream.getName());
        }
        sb.popIndent();
    }
}

