/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.moves;

import gre.svman4.LeonidasInfo;
import gre.svman4.moves.MovingOrder;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class Move {
    protected static Rectangle2D _movingArea;
    protected static double WALL_MARGIN;
    protected RobotState _mineRobot;
    protected FieldPoint nextPoint = new FieldPoint();

    static {
        WALL_MARGIN = LeonidasInfo.WALL_MARGIN;
    }

    public Move(RobotState mineRobot) {
        this._mineRobot = mineRobot;
    }

    public Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, 0.9f, 0.9f);
    }

    public MovingOrder getMovingOrder(FieldPoint point) {
        MovingOrder order = new MovingOrder();
        order.movingAngle = this._mineRobot.getAngleTo(point);
        order.distance = this._mineRobot.distance(point);
        order.speed = 8.0;
        return order;
    }

    public abstract String getName();

    protected MovingOrder goTo(FieldPoint newPoint) {
        double _directionAngle = newPoint.getAngleTo(this._mineRobot);
        MovingOrder order = new MovingOrder(_directionAngle, 8.0);
        order.distance = this._mineRobot.distance(newPoint);
        return order;
    }

    public void onPaint(Graphics2D paint) {
        paint.draw(_movingArea);
    }

    public abstract MovingOrder getMovingInfo();

    public void setMovingArea(Rectangle2D movingArea) {
        _movingArea = new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN, movingArea.getWidth() - 2.0 * WALL_MARGIN, movingArea.getHeight() - 2.0 * WALL_MARGIN);
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }
}

