/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.gun;

import catcat20.atom.gun.Gun;
import catcat20.atom.gun.WaveGun;
import catcat20.atom.gun.gf.AntiSurferGun;
import catcat20.atom.gun.gf.GuessFactorGun;
import catcat20.atom.gun.perceptual.AntiSurferFirstShot;
import catcat20.atom.gun.pif.PlayItForward;
import catcat20.atom.move.surf.Surfing;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.Wave;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class AtomGun {
    public boolean isMelee = true;
    public static int duelShotFired = 0;
    public static int meleeShotFired = 0;
    public static double duelHitCount = 0.0;
    public static double duelFireCount = 0.0;
    public static double meleeHitCount = 0.0;
    public static double meleeFireCount = 0.0;
    public TeamRobot _robot;
    public ArrayList<Wave> waves;
    public ArrayList<VBullet> vBullets;
    public static ArrayList<Gun> guns;
    public static ArrayList<WaveGun> waveGuns;
    public static Gun lastBestGun;
    public static PlayItForward meleeGun;
    public static AntiSurferFirstShot asFirstShot;
    Point2D.Double _myPos = null;
    long _time;
    long noFireTime = 0L;
    public static double lastDuelAngle;
    public static final double MAX_BOT_HALF_WIDTH;
    Wave lastFireWave = null;
    Wave lastHitWave = null;
    double currentGF = 0.0;

    public AtomGun(TeamRobot robot) {
        if (guns == null) {
            guns = new ArrayList();
            waveGuns = new ArrayList();
        }
        this._robot = robot;
        meleeGun = new PlayItForward(robot);
        GuessFactorGun gfGun = new GuessFactorGun(robot);
        guns.add(gfGun);
        waveGuns.add(gfGun);
        AntiSurferGun asGun = new AntiSurferGun(robot);
        guns.add(asGun);
        waveGuns.add(asGun);
        PlayItForward pifGun = new PlayItForward(robot);
        guns.add(pifGun);
        asFirstShot = new AntiSurferFirstShot(robot);
        waveGuns.add(asFirstShot);
    }

    public void init() {
        this.waves = new ArrayList();
        this.vBullets = new ArrayList();
        for (Gun gun : guns) {
            gun.init();
        }
        meleeGun.init();
    }

    public void onTick() {
        this._time = this._robot.getTime();
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        boolean bl = this.isMelee = this._robot.getOthers() > 1;
        if (this.isMelee) {
            this.meleeGun();
        } else {
            this.duelGun();
        }
    }

    public void duelGun() {
        double gunHeat = this._robot.getGunHeat();
        long time = this._robot.getTime();
        double power = AtomRader.calculatePower();
        for (Bot en : AtomRader.enemies.values()) {
            if (!en.alive || en.botStateLogs.size() <= 1) continue;
            Wave w = new Wave(Surfing.nextLocation);
            w.shotCount = (int)en.shotFired;
            w.myState = AtomRader.currentMyState;
            w.enState = en.currentState;
            double absBearing = HUtils.absoluteBearing(w.myState.getPosition(), w.enState.getPosition());
            w.prevMyState = AtomRader.oldMyStates.get(1);
            w.prevEnState = en.botStateLogs.get(1);
            w.bulletPower = power;
            w.isMeleeWave = false;
            w.direction = HUtils.sign(en.latVel);
            w.direction = 1;
            w.directAngle = absBearing;
            w.fireTime = time;
            w.enName = en.name;
            w.isRealWave = gunHeat == 0.0;
            w.enDirChangeTime = en.dirChangeTime;
            w.enDist16 = en.currentState.getPosition().distance(en.botStateLogs.get(Math.min(16, en.botStateLogs.size() - 1)).getPosition());
            w.enDist30 = en.currentState.getPosition().distance(en.botStateLogs.get(Math.min(30, en.botStateLogs.size() - 1)).getPosition());
            w.enDist60 = en.currentState.getPosition().distance(en.botStateLogs.get(Math.min(60, en.botStateLogs.size() - 1)).getPosition());
            w.enDist120 = en.currentState.getPosition().distance(en.botStateLogs.get(Math.min(120, en.botStateLogs.size() - 1)).getPosition());
            double[] meas = this.getMea(power, w.enState, w.myState, this._time);
            double meaWallAhead = meas[1];
            double meaWallReverse = meas[0];
            w.enMeaWallAhead = meaWallAhead;
            w.enMeaWallReverse = meaWallReverse;
            this.waves.add(w);
            this.lastFireWave = w;
        }
        Bot bot = AtomRader.nearestBot;
        if (bot != null) {
            BotState enemy = bot.currentState;
            if (enemy != null) {
                double perfectAngle;
                double absBearing = HUtils.absoluteBearing(this._myPos, enemy.getPosition());
                this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this._robot.getGunHeadingRadians())));
                boolean doFire = false;
                if ((double)time > 3.0 / HConstants.GUN_COOLING_RATE + 10.0 && this._robot.getGunTurnRemaining() <= 5.0) {
                    doFire = true;
                }
                if (enemy.getPosition().distance(this._myPos) <= 250.0) {
                    doFire = true;
                }
                if (enemy.getEnergy() <= 0.0 && this.noFireTime <= 250L) {
                    doFire = false;
                    ++this.noFireTime;
                } else {
                    this.noFireTime = 0L;
                }
                if (this._robot.getEnergy() <= power + 0.1 || this._robot.getGunHeat() >= 0.1) {
                    doFire = false;
                }
                double bestAngle = 0.0;
                double bestHit = Double.NEGATIVE_INFINITY;
                Gun bestGun = null;
                for (Gun gun : guns) {
                    gun.execute();
                    double angle = gun.getAngle();
                    if (doFire) {
                        VBullet vBullet = new VBullet();
                        vBullet.firePos = (Point2D.Double)this._myPos.clone();
                        vBullet.fireTime = time;
                        vBullet.angle = angle;
                        vBullet.power = power;
                        vBullet.fireGun = gun;
                        this.vBullets.add(vBullet);
                        bot.gunHitCount.get((Object)gun).shotCount += 1.0;
                    }
                    if (!(bestHit < bot.gunHitCount.get((Object)gun).hitCount)) continue;
                    bestGun = gun;
                    bestHit = bot.gunHitCount.get((Object)gun).hitCount;
                    bestAngle = angle;
                }
                for (WaveGun waveGun : waveGuns) {
                    waveGun.update(this.lastFireWave);
                }
                if (asFirstShot != null && this._robot.getRoundNum() <= 0 && this._robot.getTime() <= 120L) {
                    bestAngle = asFirstShot.getAngle();
                }
                if (!Double.isNaN(perfectAngle = this.getGuaranteedHitAngle(power, enemy))) {
                    bestAngle = perfectAngle;
                }
                if (bestGun != null) {
                    lastDuelAngle = bestGun.getAngle();
                    if (this._robot.getGunHeat() / this._robot.getGunCoolingRate() < 3.01) {
                        double noise = Math.random() / 500.0 - 0.025;
                        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(bestAngle - this._robot.getGunHeadingRadians() + noise)));
                        if (doFire) {
                            Bullet bullet = this._robot.setFireBullet(power);
                            bot.shotFired += 1.0;
                            if (bullet != null && this._robot.getOthers() <= 1) {
                                duelFireCount += 1.0;
                            }
                        }
                    }
                    if (lastBestGun != bestGun) {
                        System.out.println("Switching to " + bestGun.getLabel() + "Gun.    (" + 100.0 * bot.gunHitCount.get((Object)bestGun).hitCount / bot.gunHitCount.get((Object)bestGun).shotCount + "%)");
                    }
                    lastBestGun = bestGun;
                }
            }
            this.updateVBullets();
            this.updateWaves();
        }
    }

    public double getGuaranteedHitAngle(double power, BotState en) {
        double[] angles0 = this.hitWidth(power, this._myPos, en, 1);
        double[] angles1 = this.hitWidth(power, this._myPos, en, -1);
        if (angles1[0] > angles0[1] || angles0[0] > angles1[1]) {
            return Double.NaN;
        }
        return 0.5 * (Math.max(angles0[0], angles1[0]) + Math.min(angles0[1], angles1[1]));
    }

    public double[] hitWidth(double power, Point2D.Double myPos, BotState en, int direction) {
        double[] angles = new double[2];
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.getPosition().x, en.getPosition().y, en.getHeading(), en.getVelocity(), 0L);
        double absBearing = HUtils.absoluteBearing(en.getPosition(), myPos);
        double distance = myPos.distance(en.getPosition());
        double distanceTraveled = 0.0;
        double goAngle = absBearing + 1.5707963267948966 * (double)direction;
        double currentDistance = 0.0;
        MovementPredictor.PredictionStatus newStatus = status;
        while ((distanceTraveled += Rules.getBulletSpeed((double)power)) < (currentDistance = myPos.distance(newStatus = MovementPredictor.predict(newStatus, goAngle, 8.0)))) {
        }
        double angle1 = HUtils.absoluteBearing(this._myPos, HUtils.project(newStatus, goAngle, 18.0));
        double angle2 = HUtils.absoluteBearing(this._myPos, HUtils.project(newStatus, goAngle, -18.0));
        angles[0] = Math.min(angle1, angle2);
        angles[1] = Math.max(angle1, angle2);
        return angles;
    }

    public double[] getMea(double power, BotState en, BotState myState, long time) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.getPosition().x, en.getPosition().y, en.getHeading(), en.getVelocity(), time);
        double absBearing = HUtils.absoluteBearing(myState.getPosition(), en.getPosition());
        double distance = myState.getPosition().distance(en.getPosition());
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = myState.getPosition().distance(dir1);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir1, myState.getPosition()) + 1.5707963267948966;
            angle = this.wallSmoothing(dir1, angle, -1);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = myState.getPosition().distance(dir2);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = HUtils.absoluteBearing(dir2, myState.getPosition()) - 1.5707963267948966;
            angle = this.wallSmoothing(dir2, angle, 1);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir1) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(myState.getPosition(), dir2) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!HConstants.field.contains(HUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05 * 2.0;
        }
        return angle;
    }

    public void updateWaves() {
        long time = this._robot.getTime();
        for (int x = 0; x < this.waves.size(); ++x) {
            Wave ew = this.waves.get(x);
            Bot en = AtomRader.nearestBot;
            if (en == null || !en.alive) continue;
            en.currentState.currentGF = this.currentGF = ew.guessAngle(en.currentState.getPosition());
            ew.distanceTraveled = (double)(time - ew.fireTime) * ew.bulletVelocity();
            if (!(ew.distanceTraveled > this._myPos.distance(en.currentState.getPosition()) + MAX_BOT_HALF_WIDTH)) continue;
            for (WaveGun gun : waveGuns) {
                gun.logHit(ew, en.currentState.getPosition());
            }
            this.lastHitWave = ew;
            this.waves.remove(x);
            --x;
        }
    }

    public void updateVBullets() {
        Graphics2D g = this._robot.getGraphics();
        long time = this._robot.getTime();
        block0: for (int i = 0; i < this.vBullets.size(); ++i) {
            VBullet vBullet = this.vBullets.get(i);
            Point2D.Double pos = HUtils.project(vBullet.firePos, vBullet.angle, (double)(time - vBullet.fireTime) * vBullet.bulletVelocity());
            g.setColor(vBullet.fireGun.getColor());
            g.fillOval((int)pos.x - 2, (int)pos.y - 2, 4, 4);
            for (Bot en : AtomRader.enemies.values()) {
                if (!(en.alive && en.currentState.getPosition().distance(pos) <= 18.0 * Math.sqrt(2.0)) && this._time - vBullet.fireTime <= 1000L) continue;
                en.gunHitCount.get((Object)vBullet.fireGun).hitCount += 1.0;
                this.vBullets.remove(i);
                --i;
                continue block0;
            }
        }
    }

    public void meleeGun() {
        meleeGun.execute();
        if (AtomRader.nearestBot != null && AtomRader.nearestBot.currentState != null) {
            Bullet bullet;
            double absAngle = HUtils.absoluteBearing(this._myPos, AtomRader.nearestBot.currentState.getPosition());
            double power = AtomRader.calculatePower();
            boolean shouldFire = true;
            if (this._robot.getGunHeat() <= HConstants.GUN_COOLING_RATE * 10.0) {
                absAngle = meleeGun.getAngle();
            }
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((absAngle += Math.random() / 200.0 - 0.0025) - this._robot.getGunHeadingRadians())));
            if (this._robot.getGunTurnRemaining() <= 1.0 && this._robot.getEnergy() > power + 0.1 && shouldFire && (bullet = this._robot.setFireBullet(power)) != null) {
                if (this._robot.getOthers() <= 1) {
                    duelFireCount += 1.0;
                    ++duelShotFired;
                } else {
                    meleeFireCount += 1.0;
                    ++meleeShotFired;
                }
            }
        }
    }

    public void onRoundEnded() {
        System.out.println();
        System.out.println("***** gun *****");
        for (Bot bot : AtomRader.enemies.values()) {
            for (Gun gun : guns) {
                double hitRate = 100.0 * bot.gunHitCount.get((Object)gun).hitCount / bot.gunHitCount.get((Object)gun).shotCount;
                System.out.println("[" + bot.name + "] " + gun.getLabel() + " hit rate: " + hitRate + "%");
            }
        }
        System.out.println();
        System.out.println("duel hit rate: " + 100.0 * (duelHitCount / duelFireCount) + "%");
        System.out.println("melee hit rate: " + 100.0 * (meleeHitCount / meleeFireCount) + "%");
        System.out.println();
    }

    public Wave nearestWave(Point2D.Double hitLocation) {
        Wave nearestWave = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (Wave w : this.waves) {
            double dist = w.distance(hitLocation) - w.distanceTraveled;
            if (!(bestDist > dist)) continue;
            bestDist = dist;
            nearestWave = w;
        }
        return nearestWave;
    }

    public void onBulletHit(BulletHitEvent e) {
        Bot bot;
        Point2D.Double hitLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        Wave nearestWave = this.nearestWave(hitLocation);
        if (this._robot.getOthers() <= 1) {
            duelHitCount += 1.0;
            for (Gun gun : guns) {
                gun.onBulletHit(e, nearestWave);
            }
        } else {
            meleeHitCount += 1.0;
        }
        if ((bot = AtomRader.getBot(e.getName())) != null && bot.alive && bot.botStateLogs.size() > 2) {
            bot.botStateLogs.get(1).setEnergy(e.getEnergy());
            bot.botStateLogs.get(0).setEnergy(e.getEnergy());
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double hitLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        Wave nearestWave = this.nearestWave(hitLocation);
        if (this._robot.getOthers() <= 1) {
            for (Gun gun : guns) {
                gun.onBulletHitBullet(e, nearestWave);
            }
        }
    }

    public void onPaint(Graphics2D g) {
        if (this.isMelee) {
            meleeGun.onPaint(g);
        } else {
            for (Gun gun : guns) {
                gun.onPaint(g);
            }
        }
    }

    static {
        lastDuelAngle = 0.0;
        MAX_BOT_HALF_WIDTH = Math.sqrt(2.0) * 18.001;
    }

    public static class VBullet {
        public Gun fireGun;
        public Point2D.Double firePos;
        public double angle;
        public double power;
        public long fireTime;

        public double bulletVelocity() {
            return Rules.getBulletSpeed((double)this.power);
        }
    }
}

