/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.misc.logger;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.geom.Point2D;

public class circularGun
extends baseGun {
    public circularGun() {
        this.gunName = "circular";
        this.gunColor = new Color(0, 0, 255, 128);
    }

    public circularGun(EvBot evBot) {
        this();
        this.myBot = evBot;
        this.calcGunSettings();
    }

    @Override
    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot, long l) {
        Point2D.Double double_2 = this.findTargetHitPositionWithCircularPredictor(double_, d, infoBot, l);
        return double_2;
    }

    public Point2D.Double findTargetHitPositionWithCircularPredictor(Point2D.Double double_, double d, InfoBot infoBot, long l) {
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        double d2 = physics.bulletSpeed(d);
        int n = 10;
        long l2 = this.myBot.getTime() + l;
        logger.noise("Bullet speed " + d2);
        double_2 = this.predictBotPositionAtTimeCircular(infoBot, l2);
        logger.noise("Estimated target position at firing time " + double_2.x + ", " + double_2.y);
        double d3 = double_2.distance(double_);
        long l3 = (long)(d3 / d2);
        long l4 = 0L;
        for (int i = 0; Math.abs(l4 - l3) > 1L && i < n; ++i) {
            l4 = l3;
            double_2 = this.predictBotPositionAtTimeCircular(infoBot, l2 + l4);
            d3 = double_2.distance(double_);
            l3 = (long)(d3 / d2);
        }
        logger.noise("Predicted target position " + double_2.x + ", " + double_2.y);
        return double_2;
    }
}

