/*
 * Decompiled with CFR 0.152.
 */
package mc2.enemy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import mc2.enemy.CircularArrayList;
import mc2.enemy.Enemy;
import mc2.enemy.EnemyManager;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Original
extends AdvancedRobot {
    private byte moveDirection = 1;
    double WorseScanAge = 0.0;
    double ScanAge = 0.0;
    double ClosestEnnemy = 99999.0;
    double StatHit = 1.0;
    double StatMiss = 1.0;
    static int wallColision;
    static int robotColision;
    double totalDanger;
    RobotState me;
    RobotState target;
    static Vector guns;
    static Vector virtualBullets;
    Rectangle2D.Double battlefield;
    public static EnemyManager enemyMan;
    public Enemy enemy;
    public Enemy Target;
    public ArrayList<String> EnnemyName = new ArrayList();
    List<Double> EnnemyAge = new ArrayList<Double>();
    public CircularArrayList<Point2D.Double> ArrayOfFear = new CircularArrayList(10);
    public CircularArrayList<Point2D.Double> ArrayOfDanger = new CircularArrayList(10);

    static {
        virtualBullets = new Vector();
        enemyMan = new EnemyManager();
    }

    public void run() {
        this.setColors(Color.darkGray, Color.orange, Color.red, Color.magenta, Color.magenta);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setTurnRight(90.0);
        this.setTurnGunRight(180.0);
        this.setTurnRadarRight(720.0);
        this.battlefield = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        if (guns == null) {
            guns = new Vector();
        }
        virtualBullets.clear();
        while (true) {
            for (String object : this.EnnemyName) {
                this.ScanAge = this.getTime() - enemyMan.get(object).getTime();
                this.EnnemyAge.add(this.ScanAge);
                if (!(this.ScanAge > this.WorseScanAge)) continue;
                this.WorseScanAge = this.ScanAge;
            }
            this.me = new RobotState();
            this.me.name = this.getName();
            this.me.velocity = this.getVelocity();
            this.me.heading = this.getHeadingRadians();
            this.me.x = this.getX();
            this.me.y = this.getY();
            this.me.energy = this.getEnergy();
            double ClosestDistance = 9999999.0;
            for (String object : this.EnnemyName) {
                Enemy e = enemyMan.get(object);
                if (!(ClosestDistance - 50.0 > e.getDistance())) continue;
                ClosestDistance = e.getDistance();
                this.Target = e;
            }
            Iterator i = virtualBullets.iterator();
            block3: while (i.hasNext()) {
                VirtualBullet virtualBullet = (VirtualBullet)i.next();
                virtualBullet.setLocation(virtualBullet.project(virtualBullet.heading, virtualBullet.velocity));
                for (String object : this.EnnemyName) {
                    Enemy e = enemyMan.get(object);
                    if (virtualBullet.distance(e.getLocation()) < 25.0) {
                        virtualBullet.gunUsed.hits += 1.0;
                        i.remove();
                        continue block3;
                    }
                    if (!this.battlefield.contains(virtualBullet)) {
                        virtualBullet.gunUsed.miss += 1.0;
                        i.remove();
                        continue block3;
                    }
                    if (!(virtualBullet.gunUsed.hits > 15.0) && !(virtualBullet.gunUsed.miss > 15.0)) continue;
                    virtualBullet.gunUsed.miss /= 2.0;
                    virtualBullet.gunUsed.hits /= 2.0;
                }
            }
            if (this.getDistanceRemaining() > this.getBattleFieldWidth() / 3.0 || this.getDistanceRemaining() < 5.0 || this.getVelocity() < 1.0 || this.ClosestEnnemy < 100.0) {
                this.move();
            }
            this.getScannedRobotEvents();
            if (this.Target != null) {
                this.gun();
            }
            this.execute();
        }
    }

    public void move() {
        List<Object> DestinationList = new ArrayList();
        DestinationList = this.SafeArea();
        destination dest = new destination();
        Point2D.Double center = new Point2D.Double(this.getBattleFieldHeight() / 2.0, this.getBattleFieldWidth() / 2.0);
        String ClosestEnemyName = "";
        double ClosestEnemyDistance = 99999.0;
        for (String e : this.EnnemyName) {
            if (!(enemyMan.get(e).getDistance() < ClosestEnemyDistance)) continue;
            ClosestEnemyName = e;
            ClosestEnemyDistance = enemyMan.get(e).getDistance();
        }
        double weight = ClosestEnemyDistance < 295.0 ? (double)this.EnnemyName.size() * (300.0 / ClosestEnemyDistance) : (double)this.EnnemyName.size();
        double Angle = 0.0;
        double BestAvgA = 0.0;
        double DistE = 0.0;
        double FactorAD = 0.0;
        for (destination destination2 : DestinationList) {
            destination2.AvgAngle = 0.0;
            destination2.AvgDist = 0.0;
            double TotalWeight = 0.0;
            destination2.AvgDist = destination2.distance(center);
            destination2.AvgDist = destination2.distance(center) > this.getBattleFieldWidth() / 3.0 ? destination2.distance(center) * 2.0 : this.getBattleFieldWidth() / 3.0 * 2.0;
            for (Point2D.Double Fear : this.ArrayOfFear) {
                destination2.AvgDist += destination2.distance(Fear);
            }
            for (Point2D.Double Danger : this.ArrayOfDanger) {
                weight = 1.0;
                Angle = this.find_angle(Danger, destination2, this.me);
                if (Angle > (FactorAD = Danger.distance(this.me) > 120.0 ? 3.49066 : 418.8792 / Danger.distance(this.me)) / 2.0) {
                    Angle = FactorAD - Angle;
                }
                weight = 1.0;
                destination2.AvgAngle = destination2.AvgAngle + Angle + Angle * weight;
                TotalWeight += weight;
            }
            for (String e : this.EnnemyName) {
                DistE = destination2.distance(enemyMan.get(e).getLocation());
                destination2.AvgDist += DistE;
                if (DistE < destination2.SmallestDist2Ennemy) {
                    destination2.SmallestDist2Ennemy = DistE;
                }
                if ((Angle = this.find_angle(enemyMan.get(e).getLocation(), destination2, this.me)) > (FactorAD = enemyMan.get(e).getDistance() > 120.0 ? 3.49066 : 418.8792 / enemyMan.get(e).getDistance()) / 2.0) {
                    Angle = FactorAD - Angle;
                }
                weight = enemyMan.get(e).getDistance() < 150.0 ? (double)this.EnnemyName.size() * (300.0 / enemyMan.get(e).getDistance()) : 1.0;
                destination2.AvgAngle = destination2.AvgAngle + Angle + Angle * weight;
                TotalWeight += weight;
            }
            destination2.AvgAngle /= (double)this.EnnemyName.size() + TotalWeight;
            destination2.AvgDist /= (double)(this.EnnemyName.size() + 1);
            destination2.AvgAngle *= destination2.AvgDist / 400.0;
            if (!(destination2.AvgAngle > BestAvgA) || !(destination2.SmallestDist2Ennemy > 100.0) || !(destination2.distance(center) > 0.0)) continue;
            BestAvgA = destination2.AvgAngle;
            dest = destination2;
        }
        if (this.EnnemyName.size() == 1 && enemyMan.get(ClosestEnemyName).getEnergy() < 1.0 && this.getEnergy() > 10.0) {
            this.goTo2(enemyMan.get(ClosestEnemyName).getLocation());
        } else if (dest.x > 5.0) {
            this.goTo2(dest);
        }
    }

    public double find_angle(Point2D.Double p0, Point2D.Double p1, Point2D.Double c) {
        double p0c = Math.sqrt(Math.pow(c.x - p0.x, 2.0) + Math.pow(c.y - p0.y, 2.0));
        double p1c = Math.sqrt(Math.pow(c.x - p1.x, 2.0) + Math.pow(c.y - p1.y, 2.0));
        double p0p1 = Math.sqrt(Math.pow(p1.x - p0.x, 2.0) + Math.pow(p1.y - p0.y, 2.0));
        return Math.acos((p1c * p1c + p0c * p0c - p0p1 * p0p1) / (2.0 * p1c * p0c));
    }

    private double absoluteBearingRadians(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    private double normalRelativeAngleRadians(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    private void goTo(Point2D point) {
        this.setTurnRightRadians(this.normalRelativeAngleRadians(this.absoluteBearingRadians(this.me, point) - this.getHeadingRadians()));
        this.setAhead(this.me.distance(point));
    }

    private void goTo2(Point2D.Double go) {
        double x = this.getX();
        double y = this.getY();
        double angle = Utils.normalRelativeAngle((double)(Math.atan2(go.x - x, go.y - y) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead((double)(angle == turnAngle ? 1 : -1) * Point2D.distance(x, y, go.x, go.y));
    }

    public List<destination> SafeArea() {
        ArrayList<destination> DestinationList = new ArrayList<destination>();
        int limit = 55;
        double divid = this.EnnemyName.size() + 1;
        double z_x = (this.getBattleFieldWidth() - (double)(limit * 2)) / divid;
        double z_y = (this.getBattleFieldHeight() - (double)(limit * 2)) / divid;
        double s_x = 0.0;
        double s_y = 0.0;
        DestinationList.clear();
        int j = 0;
        while ((double)j < divid) {
            int i = 0;
            while ((double)i < divid) {
                boolean NoEnnemyIn = true;
                s_x = z_x * (double)j + (double)limit;
                s_y = z_y * (double)i + (double)limit;
                Rectangle2D.Double zone = new Rectangle2D.Double(s_x, s_y, z_x, z_y);
                for (String en : this.EnnemyName) {
                    Point2D.Double e = enemyMan.get(en).getLocation();
                    if (!zone.contains(e)) continue;
                    NoEnnemyIn = false;
                }
                if (NoEnnemyIn) {
                    destination pos = this.RandomPoint(z_x, z_y);
                    pos.setLocation(pos.x + s_x, pos.y + s_y);
                    if (pos.distance(this.me) > 80.0) {
                        DestinationList.add(pos);
                    }
                }
                ++i;
            }
            ++j;
        }
        return DestinationList;
    }

    public double getNextRandomDouble(double min, double max) {
        double LOWER_RANGE = min;
        double UPPER_RANGE = max;
        Random random = new Random();
        double randomValue = LOWER_RANGE + random.nextDouble() * (UPPER_RANGE - LOWER_RANGE);
        return randomValue;
    }

    public destination RandomPoint(double X, double Y) {
        boolean flag = true;
        destination xy = new destination();
        while (flag) {
            double x = this.getNextRandomDouble(0.0, X);
            double y = this.getNextRandomDouble(0.0, X);
            if (!(y <= Y)) continue;
            xy.setLocation(x, y);
            return xy;
        }
        return xy;
    }

    public void gun() {
        double bestScore = -1.0;
        Gun bestGun = null;
        for (Gun gun : guns) {
            for (String object : this.EnnemyName) {
                if (object != gun.getTarget() || !(gun.hits * (1.0 + 120.0 / enemyMan.get(object).getDistance()) * (1.0 + 20.0 / enemyMan.get(object).getEnergy()) / (gun.miss + 0.01) > bestScore)) continue;
                bestScore = gun.hits * (1.0 + 120.0 / enemyMan.get(object).getDistance()) * (1.0 + 20.0 / enemyMan.get(object).getEnergy()) / (gun.miss + 0.01);
                bestGun = gun;
            }
        }
        if (bestGun == null) {
            return;
        }
        this.target = this.setTarget(enemyMan.get(bestGun.getTarget()));
        double BULLET_POWER = this.getBulletPower(this.target, bestGun);
        this.setTurnGunRightRadians(Original.normalizeRelativeAngle(bestGun.getFiringAngle(this.me, this.target, BULLET_POWER) - this.getGunHeadingRadians()));
        Bullet b = null;
        if (this.getGunHeat() == 0.0 && this.getGunTurnRemaining() < 2.0 && this.me.energy > BULLET_POWER + 0.2) {
            b = this.setFireBullet(BULLET_POWER);
        }
        if (b != null) {
            for (String object : this.EnnemyName) {
                Enemy e = enemyMan.get(object);
                RobotState t = this.setTarget(e);
                for (Gun gun : guns) {
                    if (t.name != gun.getTarget()) continue;
                    BULLET_POWER = this.getBulletPower(t, gun);
                    VirtualBullet newVirtualBullet = new VirtualBullet();
                    newVirtualBullet.setLocation(this.me);
                    newVirtualBullet.heading = gun.getFiringAngle(this.me, t, BULLET_POWER);
                    newVirtualBullet.velocity = 20.0 - 3.0 * BULLET_POWER;
                    newVirtualBullet.gunUsed = gun;
                    virtualBullets.add(newVirtualBullet);
                }
            }
        }
    }

    public double getBulletPower(RobotState t, Gun g) {
        double BULLET_POWER = 0.1;
        if ((g.hits / (g.hits + g.miss + 0.01) < 0.34 || this.StatHit / (this.StatHit + this.StatMiss + 0.01) < 0.34) && (t.energy + 10.0 > this.me.energy || this.EnnemyName.size() > 1 && this.me.energy < 20.0)) {
            BULLET_POWER = 0.1;
        } else if (this.StatHit / (this.StatHit + this.StatMiss + 0.01) > 0.34) {
            BULLET_POWER = 3.0;
        } else {
            BULLET_POWER = Math.abs(300.0 / t.distance(this.me));
            if (BULLET_POWER < 1.1) {
                BULLET_POWER = 1.1;
            } else if (BULLET_POWER > 3.0) {
                BULLET_POWER = 3.0;
            }
        }
        if (t.energy <= 4.0) {
            BULLET_POWER = t.energy / 4.0;
        } else if (t.energy < 4.0 * BULLET_POWER + 2.0 * Math.max(BULLET_POWER - 1.0, 0.0)) {
            BULLET_POWER = (t.energy + 2.0) / 6.0;
        }
        if (BULLET_POWER * 5.0 > this.me.energy && t.energy > this.me.energy) {
            BULLET_POWER = this.me.energy / 5.0;
        }
        return BULLET_POWER;
    }

    public RobotState setTarget(Enemy e) {
        RobotState t = new RobotState();
        t.setLocation(e.getLocation().x, e.getLocation().y);
        t.heading = e.getHeadingRadians();
        t.velocity = e.getVelocity();
        t.name = e.getName();
        t.energy = e.getEnergy();
        return t;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.isSentryRobot()) {
            return;
        }
        try {
            this.enemy = enemyMan.log(e, this);
        }
        catch (Exception ex) {
            this.contain(ex);
        }
        int eIndex = this.EnnemyName.indexOf(e.getName());
        if (eIndex == -1) {
            this.EnnemyName.add(e.getName());
            eIndex = this.EnnemyName.indexOf(e.getName());
        }
        Iterator i = guns.iterator();
        boolean NotFound = true;
        while (i.hasNext()) {
            Gun gun = (Gun)i.next();
            if (gun.getTarget() != e.getName()) continue;
            NotFound = false;
        }
        if (NotFound) {
            this.target = this.setTarget(this.enemy);
            Gun newGun = new RandomGun();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new HeadOnGun();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new LinearAvg5();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new LinearAvg20();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new LinearAvg40();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new LinearAvg60();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new Circular1();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new Circular5();
            newGun.target = this.target;
            guns.add(newGun);
            newGun = new Circular15();
            newGun.target = this.target;
            guns.add(newGun);
        }
        double dist = 99999.0;
        for (String ee : this.EnnemyName) {
            if (!(enemyMan.get(ee).getDistance() < dist)) continue;
            dist = enemyMan.get(ee).getDistance();
        }
        this.ClosestEnnemy = dist;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.totalDanger += 1.0;
        Point2D.Double P = new Point2D.Double();
        P.setLocation(this.getX(), this.getY());
        this.ArrayOfFear.forceAdd(P);
        P.setLocation(enemyMan.get(e.getName()).getLocation());
        this.ArrayOfDanger.forceAdd(P);
        this.move();
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Wall!!!");
        ++wallColision;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.EnnemyName.remove(this.EnnemyName.indexOf(e.getName()));
    }

    public void onDeath(DeathEvent e) {
        this.PrintDebug();
        System.out.println("Shit I'm dead!");
    }

    public void onWin(WinEvent e) {
        this.PrintDebug();
        System.out.println("Oh I win a round!!!!");
    }

    void OnHitRobot(HitRobotEvent e) {
        System.out.println("Collision with " + e.getName());
        ++robotColision;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("SkippedTurn " + e.getSkippedTurn());
    }

    public void onBulletHit(BulletHitEvent event) {
        this.StatHit += 1.0;
        if (this.StatHit > 15.0 || this.StatMiss > 15.0) {
            this.StatHit /= 2.0;
            this.StatMiss /= 2.0;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.StatMiss += 1.0;
        if (this.StatHit > 15.0 || this.StatMiss > 15.0) {
            this.StatHit /= 2.0;
            this.StatMiss /= 2.0;
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.StatMiss += 1.0;
        if (this.StatHit > 15.0 || this.StatMiss > 15.0) {
            this.StatHit /= 2.0;
            this.StatMiss /= 2.0;
        }
    }

    public void onPaint(Graphics2D g) {
        int j;
        int count = 0;
        try {
            for (String object : this.EnnemyName) {
                g.setColor(new Color(255, 255, 0, 128));
                j = count = 10;
                while (j > 0) {
                    if (enemyMan.get(object, j) != null) {
                        g.fillRect((int)Original.enemyMan.get((String)object, (int)j).getLocation().x - 20, (int)Original.enemyMan.get((String)object, (int)j).getLocation().y - 20, 35 / j, 35 / j);
                    }
                    --j;
                }
                g.setColor(new Color(255, 0, 0, 128));
                g.fillRect((int)Original.enemyMan.get((String)object).getLocation().x - 20, (int)Original.enemyMan.get((String)object).getLocation().y - 20, 40, 40);
            }
        }
        catch (Exception ex) {
            this.contain(ex);
        }
        try {
            for (VirtualBullet virtualBullet : virtualBullets) {
                g.setColor(virtualBullet.gunUsed.getColor());
                g.fillOval((int)virtualBullet.x - 3, (int)virtualBullet.y - 3, 6, 6);
            }
            int numberOfGuns = guns.size();
            j = 0;
            while (j < numberOfGuns) {
                Gun gun = (Gun)guns.elementAt(j);
                g.setColor(Color.WHITE);
                g.drawString(String.valueOf(gun.getTarget()) + " - " + gun.getName() + " - hit rate: " + (int)(gun.hits * 100.0 / (gun.hits + gun.miss + 1.0)) + "%", 20, 5 + j * 15);
                g.setColor(gun.getColor());
                g.fillOval(5, 5 + j * 15, 10, 10);
                ++j;
            }
        }
        catch (Exception ex) {
            this.contain(ex);
        }
    }

    private void RadarSweep() {
        double radarMouvement = Math.PI * 2;
        int radarDirection = 1;
        double oldestTime = this.getTime();
        if (this.EnnemyName.size() == this.getOthers()) {
            for (String object : this.EnnemyName) {
                Enemy e = enemyMan.get(object);
                if (!((double)e.getTime() < oldestTime)) continue;
                oldestTime = e.getTime();
                radarMouvement = (double)(this.getTime() - 8L) < oldestTime ? Utils.normalRelativeAngle((double)(e.getAngle() - this.getRadarHeadingRadians())) : Math.PI * 4;
            }
        }
        radarDirection = radarMouvement > 0.0 ? 1 : -1;
        this.setTurnRadarRightRadians(radarMouvement + (double)radarDirection * 0.39269908169872414);
    }

    public void onKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 80: {
                this.PrintDebug();
            }
        }
    }

    public void PrintDebug() {
        double AgeTotal = 0.0;
        for (double object : this.EnnemyAge) {
            AgeTotal = object + AgeTotal;
        }
        System.out.println("Average Ennemy Age : " + AgeTotal / (double)this.EnnemyAge.size());
        System.out.println("Worse scan Age : " + this.WorseScanAge);
        System.out.println(this.EnnemyAge);
        if (this.EnnemyName.size() == this.getOthers()) {
            for (String object : this.EnnemyName) {
                enemyMan.get(object);
                enemyMan.get(object, 5);
            }
        }
        for (Gun gun : guns) {
            System.out.println(String.valueOf(gun.getTarget()) + " - " + gun.getName() + " - hit rate: " + (int)(gun.hits * 100.0 / (gun.hits + gun.miss + 0.01)) + "%");
            System.out.println("gun.hits: " + gun.hits + ", gun.miss: " + gun.miss);
        }
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof RadarTurnCompleteCondition) {
            this.RadarSweep();
        }
    }

    public void contain(Exception e) {
        e.printStackTrace();
        try {
            PrintStream out = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(String.valueOf((int)(Math.random() * 1000.0)) + ".error")));
            e.printStackTrace(out);
            out.flush();
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static double normalizeRelativeAngle(double angle) {
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public RobotState getAvg(String target, int age) {
        int count = 0;
        RobotState avg = new RobotState();
        int j = 0;
        while (j < age) {
            if (enemyMan.get(target, j) != null) {
                count = age;
                avg.velocity += enemyMan.get(target, j).getVelocity();
                avg.heading += enemyMan.get(target, j).getHeadingRadians();
            }
            ++j;
        }
        avg.setLocation(Original.enemyMan.get((String)target).getLocation().x, Original.enemyMan.get((String)target).getLocation().y);
        avg.velocity /= (double)count;
        avg.heading /= (double)count;
        return avg;
    }

    public Point2D.Double guessPosition(String target, long when, int age) {
        double newX;
        double newY;
        double time = enemyMan.get(target).getTime();
        double diff = (double)when - time;
        double changehead = 0.0;
        double speed = 0.0;
        int j = 1;
        while (j < age + 1) {
            if (enemyMan.get(target, j) != null) {
                speed += enemyMan.get(target, j).getVelocity();
                changehead += (enemyMan.get(target, j).getHeadingRadians() - enemyMan.get(target, j - 1).getHeadingRadians()) / (double)(enemyMan.get(target, j).getTime() - enemyMan.get(target, j - 1).getTime());
            }
            ++j;
        }
        speed /= (double)age;
        if (Math.abs(changehead /= (double)age) > 1.0E-5) {
            double radius = speed / changehead;
            double tothead = diff * changehead;
            newY = Original.enemyMan.get((String)target).getLocation().y + Math.sin(enemyMan.get(target).getHeadingRadians() + tothead) * radius - Math.sin(enemyMan.get(target).getHeadingRadians()) * radius;
            newX = Original.enemyMan.get((String)target).getLocation().x + Math.cos(enemyMan.get(target).getHeadingRadians()) * radius - Math.cos(enemyMan.get(target).getHeadingRadians() + tothead) * radius;
        } else {
            newY = Original.enemyMan.get((String)target).getLocation().y + Math.cos(enemyMan.get(target).getHeadingRadians()) * enemyMan.get(target).getVelocity() * diff;
            newX = Original.enemyMan.get((String)target).getLocation().x + Math.sin(enemyMan.get(target).getHeadingRadians()) * enemyMan.get(target).getVelocity() * diff;
        }
        return new Point2D.Double(newX, newY);
    }

    class Circular1
    extends Gun {
        Circular1() {
        }

        @Override
        public String getName() {
            return "Circular1";
        }

        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            long nextTime = (int)Math.round(shooter.distanceTo(target) / (20.0 - 3.0 * bulletPower));
            long time = Original.this.getTime() + nextTime;
            Point2D.Double p = Original.this.guessPosition(target.name, time, 1);
            return shooter.absoluteAngleTo(p);
        }
    }

    class Circular15
    extends Gun {
        Circular15() {
        }

        @Override
        public String getName() {
            return "Circular15";
        }

        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            long nextTime = (int)Math.round(shooter.distanceTo(target) / (20.0 - 3.0 * bulletPower));
            long time = Original.this.getTime() + nextTime;
            Point2D.Double p = Original.this.guessPosition(target.name, time, 15);
            return shooter.absoluteAngleTo(p);
        }
    }

    class Circular5
    extends Gun {
        Circular5() {
        }

        @Override
        public String getName() {
            return "Circular5";
        }

        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            long nextTime = (int)Math.round(shooter.distanceTo(target) / (20.0 - 3.0 * bulletPower));
            long time = Original.this.getTime() + nextTime;
            Point2D.Double p = Original.this.guessPosition(target.name, time, 5);
            return shooter.absoluteAngleTo(p);
        }
    }

    class FieldPoint
    extends Point2D.Double {
        public FieldPoint() {
        }

        public FieldPoint(double x, double y) {
            super(x, y);
        }

        public double absoluteAngleTo(FieldPoint p) {
            double angle = Math.atan2(p.x - this.x, p.y - this.y);
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            while (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            return angle;
        }

        public double absoluteAngleTo(Point2D.Double p) {
            double angle = Math.atan2(p.x - this.x, p.y - this.y);
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            while (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            return angle;
        }

        public FieldPoint project(double angle, double distance) {
            return new FieldPoint(this.x + Math.sin(angle) * distance, this.y + Math.cos(angle) * distance);
        }

        public double distanceTo(Point2D.Double that) {
            double dx = this.x - that.x;
            double dy = this.y - that.y;
            return Math.sqrt(dx * dx + dy * dy);
        }
    }

    abstract class Gun {
        public RobotState target;
        public double hits;
        public double miss;

        Gun() {
        }

        public abstract Color getColor();

        public abstract String getName();

        public String getTarget() {
            return this.target.name;
        }

        public abstract double getFiringAngle(RobotState var1, RobotState var2, double var3);
    }

    class HeadOnGun
    extends Gun {
        HeadOnGun() {
        }

        @Override
        public String getName() {
            return "Head on";
        }

        @Override
        public Color getColor() {
            return Color.BLUE;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            return shooter.absoluteAngleTo(target);
        }
    }

    class LinearAvg20
    extends Gun {
        LinearAvg20() {
        }

        @Override
        public String getName() {
            return "Linear Avg 20";
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            RobotState m = new RobotState();
            m = Original.this.getAvg(target.name, 20);
            double directAngle = shooter.absoluteAngleTo(m);
            return directAngle - m.velocity * Math.sin(directAngle - m.heading) / (20.0 - 3.0 * bulletPower);
        }
    }

    class LinearAvg40
    extends Gun {
        LinearAvg40() {
        }

        @Override
        public String getName() {
            return "Linear Avg 40";
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            RobotState m = new RobotState();
            m = Original.this.getAvg(target.name, 40);
            double directAngle = shooter.absoluteAngleTo(m);
            return directAngle - m.velocity * Math.sin(directAngle - m.heading) / (20.0 - 3.0 * bulletPower);
        }
    }

    class LinearAvg5
    extends Gun {
        LinearAvg5() {
        }

        @Override
        public String getName() {
            return "Linear Avg 5";
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            RobotState m = new RobotState();
            m = Original.this.getAvg(target.name, 5);
            double directAngle = shooter.absoluteAngleTo(m);
            return directAngle - m.velocity * Math.sin(directAngle - m.heading) / (20.0 - 3.0 * bulletPower);
        }
    }

    class LinearAvg60
    extends Gun {
        LinearAvg60() {
        }

        @Override
        public String getName() {
            return "Linear Avg 60";
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            RobotState m = new RobotState();
            m = Original.this.getAvg(target.name, 60);
            double directAngle = shooter.absoluteAngleTo(m);
            return directAngle - m.velocity * Math.sin(directAngle - m.heading) / (20.0 - 3.0 * bulletPower);
        }
    }

    class MotionState
    extends FieldPoint {
        public double velocity;
        public double heading;

        MotionState() {
        }
    }

    class RandomGun
    extends Gun {
        RandomGun() {
        }

        @Override
        public String getName() {
            return "Simple linear gun";
        }

        @Override
        public Color getColor() {
            return Color.BLUE;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle - target.velocity * Math.sin(directAngle - target.heading) / (20.0 - 3.0 * bulletPower);
        }
    }

    class ReallyBadGun
    extends Gun {
        ReallyBadGun() {
        }

        @Override
        public String getName() {
            return "Really bad gun - fires away from the enemy";
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            return target.absoluteAngleTo(shooter);
        }
    }

    class RobotState
    extends MotionState {
        public String name;
        public double energy;

        RobotState() {
        }
    }

    class VirtualBullet
    extends MotionState {
        public Gun gunUsed;

        VirtualBullet() {
        }
    }

    class destination
    extends FieldPoint {
        double SmallestDist2Ennemy = 9.999999999E9;
        double AvgAngle = 0.0;
        double AvgDist = 0.0;

        destination() {
        }
    }
}

