/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.Iterator;
import pedersen.core.Targetable;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.opponent.Target;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.targeting.TargetingMethod;

public class OpponentProfile
implements Debuggable {
    private final String name;
    private String badMovements;
    private String badTargeting;
    public static final String section = ";";
    private static final String crlf = "\n";
    private static final int idOffset = 97;

    public OpponentProfile(Target target) {
        this.name = target.getName();
        this.badMovements = "";
        this.badTargeting = "";
    }

    public OpponentProfile(String profile) {
        int pointer1 = 0;
        int pointer2 = profile.indexOf(section, pointer1);
        this.name = profile.substring(pointer1, pointer2);
        pointer1 = pointer2 + 1;
        pointer2 = profile.indexOf(section, pointer1);
        if (pointer2 > 0) {
            this.badMovements = profile.substring(pointer1, pointer2);
        }
        if ((pointer2 = profile.indexOf(section, pointer1 = pointer2 + 1)) > 0) {
            this.badTargeting = profile.substring(pointer1, pointer2);
        }
    }

    public boolean equals(Target target) {
        return this.name.compareTo(target.getName()) == 0;
    }

    public boolean equals(String name) {
        return this.name.compareTo(name) == 0;
    }

    public void disqualifyMovementMethod(int movementMethodId) {
        this.badMovements = String.valueOf(this.badMovements) + (char)(movementMethodId + 97);
    }

    public void disqualifyTargetingMethod(int targetingMethodId) {
        this.badTargeting = String.valueOf(this.badTargeting) + (char)(targetingMethodId + 97);
    }

    public String getProfile() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name).append(section);
        buffer.append(this.badMovements).append(section);
        buffer.append(this.badTargeting).append(section);
        return buffer.append(crlf).toString();
    }

    public void synchronize(Targetable target) {
        this.synchronizeMovementsLibraryToTarget(target);
        this.synchronizeMovementsTargetToLibrary(target);
    }

    private void synchronizeMovementsLibraryToTarget(Targetable target) {
        int i = 0;
        while (i < this.badMovements.length()) {
            int badMovementMethodId = this.badMovements.charAt(i) - 97;
            Iterator iterator = target.getMovementMethods().getDynamicMovementMethods().iterator();
            while (iterator.hasNext()) {
                if (((MovementMethod)iterator.next()).getPersistenceId() != badMovementMethodId) continue;
                iterator.remove();
            }
            ++i;
        }
    }

    protected void synchronizeTargetingLibraryToTarget(Targetable target) {
        int i = 0;
        while (i < this.badTargeting.length()) {
            int badTargetingMethodId = this.badTargeting.charAt(i) - 97;
            if (badTargetingMethodId != 8 && badTargetingMethodId != 14) {
                Iterator iterator = target.getDefensiveTargetingMethods().iterator();
                while (iterator.hasNext()) {
                    if (((TargetingMethod)iterator.next()).getPersistenceId() != badTargetingMethodId) continue;
                    iterator.remove();
                }
            }
            ++i;
        }
    }

    private void synchronizeMovementsTargetToLibrary(Targetable target) {
        if (target.getMovementMethods().getDynamicMovementMethods().size() > 3) {
            MovementMethod worstMovementMethod = null;
            double worstMovementMethodHitRatio = 0.0;
            boolean allMovementMethodsHaveMoreThanZeroTimeInUse = true;
            Iterator iterator = target.getMovementMethods().getDynamicMovementMethods().iterator();
            while (iterator.hasNext() && allMovementMethodsHaveMoreThanZeroTimeInUse) {
                MovementMethod movementMethod = (MovementMethod)iterator.next();
                int hitTally = movementMethod.getHitTally();
                int timeInUse = movementMethod.getTimeInUse();
                if (timeInUse == 0) {
                    allMovementMethodsHaveMoreThanZeroTimeInUse = false;
                    continue;
                }
                double hitRatio = (double)hitTally / (double)timeInUse;
                if (!(hitRatio > worstMovementMethodHitRatio)) continue;
                worstMovementMethod = movementMethod;
                worstMovementMethodHitRatio = hitRatio;
            }
            if (allMovementMethodsHaveMoreThanZeroTimeInUse) {
                this.disqualifyMovementMethod(worstMovementMethod.getPersistenceId());
            }
        }
    }

    protected void synchronizeTargetingTargetToLibrary(Targetable target) {
        if (target.getDefensiveTargetingMethods().size() > 3) {
            TargetingMethod worstTargetingMethod = null;
            double worstTargetingMethodHitRatio = 100.0;
            Iterator iterator = target.getDefensiveTargetingMethods().iterator();
            while (iterator.hasNext()) {
                TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
                double hitRatio = targetingMethod.getTargetingStatistics().getSuccessRate();
                if (!(hitRatio < worstTargetingMethodHitRatio)) continue;
                worstTargetingMethod = targetingMethod;
                worstTargetingMethodHitRatio = hitRatio;
            }
            this.disqualifyTargetingMethod(worstTargetingMethod.getPersistenceId());
        }
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + ": " + this.getProfile());
    }
}

