/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode.movement;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.MovementManager;
import com.spp.robocode.movement.MovementAlgo;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.util.Utils;

public class AntiGravityMover
implements MovementAlgo {
    private List<GravPoint> gravpoints = new ArrayList<GravPoint>();
    private AdvancedRobot robot;
    private BattlefieldModel model;
    private GravPoint avoidLocation = null;
    private int updateCount = 200;

    @Override
    public void initialise(AdvancedRobot r, BattlefieldModel m) {
        this.robot = r;
        this.model = m;
    }

    @Override
    public void doMovement() {
        this.gravpoints.clear();
        this.model.getEnemies().values().forEach(em -> {
            Enemy e = em;
            GravPoint gp = new GravPoint(e.getX(), e.getY(), e.getDistance(), -300000.0);
            this.gravpoints.add(gp);
        });
        if (this.avoidLocation == null || this.updateCount > 2) {
            this.avoidLocation = new GravPoint(this.robot.getX() + 4.0 * (Math.random() - 0.5), this.robot.getY() + 4.0 * (Math.random() - 0.5), 4.0, -400.0);
            this.updateCount = 0;
        }
        ++this.updateCount;
        this.gravpoints.add(this.avoidLocation);
        double xforce = 0.0;
        double yforce = 0.0;
        for (int i = 0; i < this.gravpoints.size(); ++i) {
            GravPoint p = this.gravpoints.get(i);
            double force = p.power / Math.pow(p.distance, 2.0);
            double ang = Utils.normalRelativeAngle((double)(1.5707963267948966 - Math.atan2(this.robot.getY() - p.y, this.robot.getX() - p.x)));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 5000000.0 / Math.pow(this.getRange(this.robot.getX(), this.robot.getY(), this.robot.getBattleFieldWidth(), this.robot.getY()), 3.0);
        yforce += 5000000.0 / Math.pow(this.getRange(this.robot.getX(), this.robot.getY(), this.robot.getX(), this.robot.getBattleFieldHeight()), 3.0);
        Point2D.Double p1 = new Point2D.Double();
        ((Point2D)p1).setLocation(this.robot.getX() - (xforce -= 5000000.0 / Math.pow(this.getRange(this.robot.getX(), this.robot.getY(), 0.0, this.robot.getY()), 3.0)), this.robot.getY() - (yforce -= 5000000.0 / Math.pow(this.getRange(this.robot.getX(), this.robot.getY(), this.robot.getX(), 0.0), 3.0)));
        MovementManager.GoToPoint(this.robot, p1);
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        System.out.println("---- ANTIGRAV HIT ROBOT ---------");
    }

    int turnTo(double angle) {
        int dir;
        double ang = Utils.normalRelativeAngle((double)(this.robot.getHeading() - angle));
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.robot.setTurnLeft(ang);
        return dir;
    }

    double getRange(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double range = Math.sqrt(x * x + y * y);
        return range;
    }

    private class GravPoint {
        public double power;
        public double distance;
        public double x;
        public double y;

        public GravPoint(double pX, double pY, double d, double pPower) {
            this.x = pX;
            this.y = pY;
            this.distance = d;
            this.power = pPower;
        }
    }
}

