/*
 * Decompiled with CFR 0.152.
 */
package cb.fire.base;

import cb.fire.base.BulletFiredInformation;
import cb.fire.base.BulletHitBulletInformation;
import cb.fire.base.BulletHitInformation;
import cb.fire.base.FirestarterBase;
import cb.fire.base.HitByBulletInformation;
import cb.fire.base.I;
import cb.fire.base.RobotScanInformation;
import cb.fire.base.Z;
import cb.fire.misc.B;
import cb.fire.misc.C;
import cb.fire.misc.MovementState;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public abstract class FirestarterBase
extends TeamRobot {
    private HashMap<String, RobotModel> Z = new HashMap();
    private MovementState atan;

    public final void run() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(new Color(172, 5, 30));
        arrayList.add(new Color(235, 193, 55));
        arrayList.add(new Color(255, 93, 55));
        Collections.shuffle(arrayList);
        this.setColors((Color)arrayList.get(0), (Color)arrayList.get(1), (Color)arrayList.get(2));
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustGunForRobotTurn(false);
        this.setTurnRightRadians(Double.POSITIVE_INFINITY);
        this.setTurnGunRightRadians(Double.POSITIVE_INFINITY);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (this.Z.size() <= this.getOthers() && this.getTime() < 7L) {
            this.execute();
        }
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.runTick();
            this.Z();
            this.execute();
        }
    }

    public final void onStatus(StatusEvent statusEvent) {
        if (statusEvent.getTime() == 0L) {
            this.initializeRound();
        }
        this.atan = new MovementState(statusEvent.getTime(), new Point2D.Double(statusEvent.getStatus().getX(), statusEvent.getStatus().getY()), statusEvent.getStatus().getHeadingRadians(), statusEvent.getStatus().getVelocity());
        this.Z.put(this.getName(), (RobotModel)new I(this, true, this.atan));
        RobotScanInformation robotScanInformation = new RobotScanInformation(this.getName(), this.atan, statusEvent.getStatus().getEnergy());
        this.process(robotScanInformation);
        try {
            this.broadcastMessage(robotScanInformation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        Point2D.Double double_ = B.I(this.atan.getLocation(), this.atan.getHeading() + scannedRobotEvent.getBearingRadians(), scannedRobotEvent.getDistance());
        MovementState movementState = new MovementState(scannedRobotEvent.getTime() - 1L, double_, scannedRobotEvent.getHeadingRadians(), scannedRobotEvent.getVelocity());
        this.Z.put(scannedRobotEvent.getName(), (RobotModel)new I(this, this.isTeammate(scannedRobotEvent.getName()), movementState));
        RobotScanInformation robotScanInformation = new RobotScanInformation(scannedRobotEvent.getName(), movementState, scannedRobotEvent.getEnergy());
        this.process(robotScanInformation);
        try {
            this.broadcastMessage(robotScanInformation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void onMessageReceived(MessageEvent messageEvent) {
        if (messageEvent.getMessage() instanceof RobotScanInformation) {
            RobotScanInformation robotScanInformation = (RobotScanInformation)messageEvent.getMessage();
            if (this.Z.containsKey(robotScanInformation.getName()) && ((I)this.Z.get((Object)robotScanInformation.getName())).Z.getTime() >= robotScanInformation.getState().getTime()) {
                return;
            }
            this.Z.put(robotScanInformation.getName(), (RobotModel)new I(this, this.isTeammate(robotScanInformation.getName()), robotScanInformation.getState()));
            this.process(robotScanInformation);
        } else if (messageEvent.getMessage() instanceof BulletFiredInformation) {
            BulletFiredInformation bulletFiredInformation = (BulletFiredInformation)messageEvent.getMessage();
            this.process(bulletFiredInformation);
        } else if (messageEvent.getMessage() instanceof BulletHitInformation) {
            BulletHitInformation bulletHitInformation = (BulletHitInformation)messageEvent.getMessage();
            this.process(bulletHitInformation);
        } else if (messageEvent.getMessage() instanceof HitByBulletInformation) {
            HitByBulletInformation hitByBulletInformation = (HitByBulletInformation)messageEvent.getMessage();
            this.process(hitByBulletInformation);
        } else if (messageEvent.getMessage() instanceof BulletHitBulletInformation) {
            BulletHitBulletInformation bulletHitBulletInformation = (BulletHitBulletInformation)messageEvent.getMessage();
            this.process(bulletHitBulletInformation);
        }
    }

    public final void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        if (this.Z.containsKey(robotDeathEvent.getName())) {
            this.Z.remove(robotDeathEvent.getName());
        }
        Z z = new Z(robotDeathEvent.getName());
        this.process(z);
    }

    public final void onBulletHit(BulletHitEvent bulletHitEvent) {
        BulletHitInformation bulletHitInformation = new BulletHitInformation(bulletHitEvent.getBullet(), bulletHitEvent.getTime());
        this.process(bulletHitInformation);
        try {
            this.broadcastMessage(bulletHitInformation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        HitByBulletInformation hitByBulletInformation = new HitByBulletInformation(hitByBulletEvent.getBullet(), hitByBulletEvent.getTime());
        this.process(hitByBulletInformation);
        try {
            this.broadcastMessage(hitByBulletInformation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        BulletHitBulletInformation bulletHitBulletInformation = new BulletHitBulletInformation(bulletHitBulletEvent.getBullet(), bulletHitBulletEvent.getHitBullet(), bulletHitBulletEvent.getTime());
        this.process(bulletHitBulletInformation);
        try {
            this.broadcastMessage(bulletHitBulletInformation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final Bullet setFireBullet(double d) {
        Bullet bullet = super.setFireBullet(d);
        if (bullet != null) {
            BulletFiredInformation bulletFiredInformation = new BulletFiredInformation(bullet, this.getTime());
            this.process(bulletFiredInformation);
            try {
                this.broadcastMessage(bulletFiredInformation);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bullet;
    }

    public void initializeRound() {
    }

    public void runTick() {
    }

    private final void Z() {
        if (this.Z.size() <= this.getOthers()) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        } else {
            long l = Long.MAX_VALUE;
            I i = null;
            double d = 0.0;
            double d2 = 0.0;
            for (String string : this.Z.keySet()) {
                I i2 = (I)this.Z.get(string);
                if (i2.I) continue;
                double d3 = B.I(this.atan.getLocation(), i2.Z.getLocation());
                double d4 = (this.atan.getTime() - i2.Z.getTime()) * 8L;
                double d5 = Math.atan(d4 / this.atan.getLocation().distance(i2.Z.getLocation()));
                d = Math.min(d, Utils.normalRelativeAngle((double)(d3 - d5 - this.getRadarHeadingRadians())));
                d2 = Math.max(d2, Utils.normalRelativeAngle((double)(d3 + d5 - this.getRadarHeadingRadians())));
                if (i2.Z.getTime() >= l) continue;
                l = i2.Z.getTime();
                i = i2;
            }
            if (i == null || this.atan.getTime() - l > 10L) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            } else {
                double d6 = B.I(this.atan.getLocation(), i.Z.getLocation());
                if (Utils.normalRelativeAngle((double)(d6 - this.getRadarHeadingRadians())) < 0.0) {
                    this.setTurnRadarRightRadians(d);
                } else {
                    this.setTurnRadarRightRadians(d2);
                }
            }
        }
    }

    public void process(RobotScanInformation robotScanInformation) {
    }

    public void process(Z z) {
    }

    public void process(BulletFiredInformation bulletFiredInformation) {
    }

    public void process(BulletHitInformation bulletHitInformation) {
    }

    public void process(HitByBulletInformation hitByBulletInformation) {
    }

    public void process(BulletHitBulletInformation bulletHitBulletInformation) {
    }

    static {
        C.I();
    }
}

