/*
 * Decompiled with CFR 0.152.
 */
package CharlieN.OmegaTeam;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import robocode.Condition;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Alpha
extends TeamRobot {
    public double power = 2.0;
    public double enemyEnergy = 100.0;
    public double newEnergy = 100.0;
    public double enemyAngle = 0.0;
    public double distance = 1000.0;
    public int timeSinceScan = 0;
    public double aimAngle = 0.0;
    public double headOnAngle = 0.0;
    public double circularAngle = 0.0;
    public double randomAngle = 0.0;
    public double averageAngle = 0.0;
    public int direction = 1;
    public double tmpX = 400.0;
    public double tmpY = 300.0;
    public double enemyBearing = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double bfWidth = 0.0;
    public double bfHeight = 0.0;
    static long headOnScore = 0L;
    static long circularScore = 0L;
    static long randomScore = 0L;
    static long averageScore = 0L;
    ArrayList<Double> firePointX = new ArrayList();
    ArrayList<Double> firePointY = new ArrayList();
    ArrayList<Double> bulletSpeed = new ArrayList();
    ArrayList<Long> firedTurn = new ArrayList();
    ArrayList<Double> headOnAngleFired = new ArrayList();
    ArrayList<Double> circularAngleFired = new ArrayList();
    ArrayList<Double> randomAngleFired = new ArrayList();
    ArrayList<Double> averageAngleFired = new ArrayList();
    ArrayList<Double> enemySpeed = new ArrayList(30);
    ArrayList<Double> enemyHeading = new ArrayList(30);
    ArrayList<Double> enemyX = new ArrayList(50);
    ArrayList<Double> enemyY = new ArrayList(50);
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    Point2D robotLocation;
    Point2D enemyLocation = new Point2D.Double(400.0, 300.0);
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

    public void run() {
        int i;
        this.addCustomEvent(new Condition("eventManager"){

            public boolean test() {
                Alpha.this.handleEvents();
                return false;
            }
        });
        this.bfWidth = this.getBattleFieldWidth();
        this.bfHeight = this.getBattleFieldHeight();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.green, Color.green, Color.green);
        for (i = 0; i < 50; ++i) {
            this.enemySpeed.add(0.0);
            this.enemyHeading.add(0.0);
            this.enemyX.add(this.bfWidth / 2.0);
            this.enemyY.add(this.bfHeight / 2.0);
        }
        while (true) {
            this.x = this.getX();
            this.y = this.getY();
            this.robotLocation = new Point2D.Double(this.getX(), this.getY());
            for (i = 0; i < this.firePointX.size(); ++i) {
                if (!((double)(this.getTime() - this.firedTurn.get(i)) * this.bulletSpeed.get(i) >= this.distanceBetween(this.enemyX.get(0), this.enemyY.get(0), this.firePointX.get(i), this.firePointY.get(i)))) continue;
                double centerAngle = Math.atan2(this.enemyX.get(0) - this.firePointX.get(i), this.enemyY.get(0) - this.firePointY.get(i));
                double centerOffsetAngle = Math.atan(20.0 / this.distanceBetween(this.enemyX.get(0), this.enemyY.get(0), this.firePointX.get(i), this.firePointY.get(i)));
                double headOnAngleI = Utils.normalRelativeAngle((double)this.headOnAngleFired.get(i));
                double circularAngleI = Utils.normalRelativeAngle((double)this.circularAngleFired.get(i));
                double randomAngleI = Utils.normalRelativeAngle((double)this.randomAngleFired.get(i));
                double averageAngleI = Utils.normalRelativeAngle((double)this.averageAngleFired.get(i));
                if (headOnAngleI >= centerAngle - centerOffsetAngle && headOnAngleI <= centerAngle + centerOffsetAngle) {
                    ++headOnScore;
                }
                if (circularAngleI >= centerAngle - centerOffsetAngle && circularAngleI <= centerAngle + centerOffsetAngle) {
                    ++circularScore;
                }
                if (randomAngleI >= centerAngle - centerOffsetAngle && randomAngleI <= centerAngle + centerOffsetAngle) {
                    ++randomScore;
                }
                if (averageAngleI >= centerAngle - centerOffsetAngle && averageAngleI <= centerAngle + centerOffsetAngle) {
                    ++averageScore;
                }
                this.out.println("Circular: " + circularScore + "  Head On: " + headOnScore + "  Random: " + randomScore + "  Average: " + averageScore);
                this.removeWave(i);
            }
            if (this.timeSinceScan > 1) {
                this.setTurnRadarRightRadians(100.0);
            } else {
                double radsOff = Utils.normalRelativeAngle((double)(this.enemyAngle - this.getRadarHeadingRadians()));
                if (radsOff > 0.0) {
                    this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(radsOff + 0.39269908169872414)));
                } else {
                    this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(radsOff - 0.39269908169872414)));
                }
            }
            this.power = this.distance > 800.0 ? 1.5 : (this.distance > 400.0 ? 2.0 : (this.distance > 200.0 ? 2.5 : 3.0));
            if (this.getEnergy() > this.newEnergy && this.getEnergy() <= this.power) {
                this.power = 0.1;
            }
            this.move();
            double dx = this.distance * Math.sin(this.enemyAngle);
            double dy = this.distance * Math.cos(this.enemyAngle);
            double dt = 0.0;
            double eDist = 0.0;
            do {
                eDist = dt > 100.0 ? this.distanceBetween(0.0, 0.0, dx += Math.sin(this.enemyHeading.get(1) + dt * (this.enemyHeading.get(0) - this.enemyHeading.get(1))) * this.enemySpeed.get(0), dy += Math.cos(this.enemyHeading.get(1) + dt * (this.enemyHeading.get(0) - this.enemyHeading.get(1))) * this.enemySpeed.get(0)) : dt * (20.0 - 3.0 * this.power);
                dt += 1.0;
            } while (eDist < this.distanceBetween(0.0, 0.0, dx, dy));
            this.circularAngle = Math.atan2(dx, dy);
            this.headOnAngle = this.enemyAngle;
            this.randomAngle = this.enemyAngle + (Math.random() + Math.random() - 1.0) * Math.asin(8.0 / (20.0 - 3.0 * this.power));
            dx = this.distance * Math.sin(this.enemyAngle);
            dy = this.distance * Math.cos(this.enemyAngle);
            dt = 0.0;
            eDist = 0.0;
            do {
                eDist = dt > 100.0 ? this.distanceBetween(0.0, 0.0, dx += (this.enemyX.get(0) - this.enemyX.get(49)) / 49.0, dy += (this.enemyY.get(0) - this.enemyY.get(49)) / 49.0) : dt * (20.0 - 3.0 * this.power);
                dt += 1.0;
            } while (eDist < this.distanceBetween(0.0, 0.0, dx, dy));
            this.averageAngle = Math.atan2(dx, dy);
            this.aimAngle = circularScore >= Math.max(Math.max(headOnScore, randomScore), averageScore) ? this.circularAngle : (averageScore >= Math.max(headOnScore, randomScore) ? this.averageAngle : (headOnScore >= randomScore ? this.headOnAngle : this.randomAngle));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.aimAngle - this.getGunHeadingRadians())));
            this.enemyEnergy = this.newEnergy;
            if (this.getGunHeat() == 0.0 && this.getEnergy() > this.power && this.timeSinceScan < 2) {
                this.setFire(this.power);
                this.addWave(this.x, this.y, this.power, this.headOnAngle, this.circularAngle, this.randomAngle, this.averageAngle);
            }
            ++this.timeSinceScan;
            this.execute();
        }
    }

    public void handleEvents() {
        for (ScannedRobotEvent e : this.getScannedRobotEvents()) {
            if (this.isTeammate(e.getName())) continue;
            this.timeSinceScan = 0;
            this.newEnergy = e.getEnergy();
            this.distance = e.getDistance();
            this.enemyAngle = e.getBearingRadians() + this.getHeadingRadians();
            this.enemySpeed.remove(29);
            this.enemySpeed.add(0, e.getVelocity());
            this.enemyHeading.remove(29);
            this.enemyHeading.add(0, e.getHeadingRadians());
            this.enemyBearing = e.getBearingRadians();
            this.enemyX.remove(49);
            this.enemyX.add(0, this.x + this.distance * Math.sin(this.enemyAngle));
            this.enemyY.remove(49);
            this.enemyY.add(0, this.y + this.distance * Math.cos(this.enemyAngle));
            this.enemyLocation = Alpha.vectorToLocation(this.enemyAngle, this.distance, this.robotLocation);
            if (!(Math.abs(this.enemySpeed.get(0) - this.enemySpeed.get(1)) > 2.0)) continue;
            this.enemyEnergy -= Rules.getWallHitDamage((double)this.enemySpeed.get(1));
        }
        for (ScannedRobotEvent e : this.getBulletHitEvents()) {
            this.enemyEnergy = e.getEnergy();
        }
        for (ScannedRobotEvent e : this.getHitByBulletEvents()) {
        }
        for (ScannedRobotEvent e : this.getRobotDeathEvents()) {
            this.firePointX.clear();
            this.firePointY.clear();
            this.bulletSpeed.clear();
            this.firedTurn.clear();
            this.headOnAngleFired.clear();
            this.circularAngleFired.clear();
            this.randomAngleFired.clear();
            this.averageAngleFired.clear();
        }
        this.clearAllEvents();
    }

    public void addWave(double firedX, double firedY, double fPower, double hOA, double cA, double rA, double aA) {
        this.firePointX.add(firedX);
        this.firePointY.add(firedY);
        this.bulletSpeed.add(20.0 - 3.0 * fPower);
        this.firedTurn.add(this.getTime());
        this.headOnAngleFired.add(hOA);
        this.circularAngleFired.add(cA);
        this.randomAngleFired.add(rA);
        this.averageAngleFired.add(aA);
    }

    public void removeWave(int waveToRemove) {
        this.firePointX.remove(waveToRemove);
        this.firePointY.remove(waveToRemove);
        this.bulletSpeed.remove(waveToRemove);
        this.firedTurn.remove(waveToRemove);
        this.headOnAngleFired.remove(waveToRemove);
        this.circularAngleFired.remove(waveToRemove);
        this.randomAngleFired.remove(waveToRemove);
        this.averageAngleFired.remove(waveToRemove);
    }

    public double distanceBetween(double pX1, double pY1, double pX2, double pY2) {
        return Math.sqrt(Math.pow(pX1 - pX2, 2.0) + Math.pow(pY1 - pY2, 2.0));
    }

    void move() {
        this.considerChangingDirection();
        Point2D robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = Alpha.vectorToLocation(Alpha.absoluteBearing(this.enemyLocation, this.robotLocation) + this.movementLateralAngle, this.distance * (1.1 - tries / 100.0), this.enemyLocation);
        } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(25.0).contains(robotDestination));
        this.goTo(robotDestination);
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(Alpha.absoluteBearing(this.robotLocation, destination) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(this.robotLocation.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return Alpha.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}

