/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicWave;
import Krabb.sliNk.Bot;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Stats;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;

public class SegmentationValues {
    static final int DISTANCE = 0;
    static final int BULLETPOWER = 1;
    static final int BULLETFLIGHTTIME = 6;
    static final int VELOCITY_V = 2;
    static final int LATERALVELOCITY_V = 3;
    static final int ACCELERATION_V = 4;
    static final int WALLDISTANCE_FORWARD_V = 5;
    static final int LASTAIMEDGF_S = 7;
    static final int TURNRATE_V = 8;
    static final int LASTVELOCITYCHANGE_V = 9;
    static final int WALLDISTANCE_BACKWARD_V = 10;
    static final int DISTANCELAST10_V = 11;
    static final int NSEGMENTTYPES = 12;
    static boolean init = false;
    double[] value = new double[12];
    static double[] value_max = new double[12];
    static double[] value_min = new double[12];

    SegmentationValues(BasicWave w, int victim_i) {
        if (!init) {
            System.out.println("SegmentationValues not initialised!!!");
            return;
        }
        Stats stats_source = w.source_stats_segmentation;
        Stats stats_victim = w.victim_stats_segmentation[victim_i];
        Bot victim = Data.getBot(stats_victim.name);
        this.value[0] = stats_source.location.distance(stats_victim.location);
        this.value[1] = w.power;
        this.value[6] = this.value[0] / (20.0 - 3.0 * this.value[1]);
        this.value[2] = stats_victim.velocity;
        this.value[3] = this.getLateralVelocity(stats_source, stats_victim);
        this.value[4] = stats_victim.acceleration;
        double[] walldistance = this.getWallDistanceValues(w, victim_i);
        int FORWARD = 0;
        int BACKWARD = 1;
        this.value[5] = walldistance[FORWARD];
        this.value[10] = walldistance[BACKWARD];
        this.value[7] = stats_victim.lastaimedgf;
        this.value[8] = stats_victim.heading_velocity;
        this.value[9] = stats_victim.time - stats_victim.velocity_lastchange_time;
        if (victim == null) {
            this.value[11] = 0.0;
        } else {
            Stats stats_tmp = victim.getTimeStats(stats_victim.time - (long)Math.min(13, victim.stats_number - 1));
            if (stats_tmp == null) {
                this.value[11] = 0.0;
            } else {
                Point2D.Double location = stats_tmp.location;
                this.value[11] = location.distance(stats_victim.location);
            }
        }
    }

    public static void initConstants(AdvancedRobot bot) {
        init = true;
        SegmentationValues.value_min[0] = 32.0;
        SegmentationValues.value_max[0] = Math.sqrt(Math.pow(bot.getBattleFieldHeight(), 2.0) + Math.pow(bot.getBattleFieldWidth(), 2.0));
        SegmentationValues.value_min[1] = 0.1;
        SegmentationValues.value_max[1] = 3.0;
        SegmentationValues.value_min[6] = value_min[0] / (20.0 - 3.0 * value_min[1]);
        SegmentationValues.value_max[6] = value_min[0] / (20.0 - 3.0 * value_max[1]);
        SegmentationValues.value_min[2] = -8.0;
        SegmentationValues.value_max[2] = 8.0;
        SegmentationValues.value_min[3] = -8.0;
        SegmentationValues.value_max[3] = 8.0;
        SegmentationValues.value_min[4] = -2.0;
        SegmentationValues.value_max[4] = 1.0;
        SegmentationValues.value_min[5] = 0.0;
        SegmentationValues.value_max[5] = 1.0;
        SegmentationValues.value_min[10] = -1.0;
        SegmentationValues.value_max[10] = 0.0;
        SegmentationValues.value_min[7] = -1.0;
        SegmentationValues.value_max[7] = 1.0;
        SegmentationValues.value_min[9] = 0.0;
        SegmentationValues.value_max[9] = Double.MAX_VALUE;
        SegmentationValues.value_min[11] = 0.0;
        SegmentationValues.value_max[11] = 13.0 * value_min[2];
    }

    public double getDistance() {
        return this.value[0];
    }

    public double getBulletBower() {
        return this.value[1];
    }

    public double getBulletFlightTime() {
        return this.value[6];
    }

    public double getVelocity_V() {
        return this.value[2];
    }

    public double getLateralVelocity_V() {
        return this.value[3];
    }

    public double getAcceleration_V() {
        return this.value[4];
    }

    public double getWallGFForward_V() {
        return this.value[5];
    }

    public double getWallGFBackward_V() {
        return this.value[10];
    }

    public double getLastAimedGF_S() {
        return this.value[7];
    }

    public double getTurnrate_V() {
        return this.value[8];
    }

    public double getLastVelocityChange_V() {
        return this.value[9];
    }

    public double getDistanceLast10() {
        return this.value[11];
    }

    private double getLateralVelocity(Stats stats_source, Stats stats_object) {
        return stats_object.velocity * Math.sin(DataHandling.absoluteAngle(stats_source.location, stats_object.location) - stats_object.heading);
    }

    private double[] getWallDistanceValues(BasicWave w, int victim) {
        double dist_wallparallel;
        double gf_positive = 1.1;
        double gf_negative = -1.1;
        Stats stats_source = w.source_stats_segmentation;
        Stats stats_victim = w.victim_stats_segmentation[victim];
        double source_walldist = Garm.field_rect_border.y + Garm.field_rect_border.height - stats_source.location.y;
        double victim_walldist = Garm.field_rect_border.y + Garm.field_rect_border.height - stats_victim.location.y;
        double dist = stats_source.location.distance(stats_victim.location);
        double gf_new = this.getWallGF(w, source_walldist, victim_walldist, dist, dist_wallparallel = stats_source.location.x - stats_victim.location.x);
        if (gf_new >= 0.0) {
            gf_positive = Math.min(gf_new, gf_positive);
        } else {
            gf_negative = Math.max(gf_new, gf_negative);
        }
        source_walldist = stats_source.location.y - Garm.field_rect_border.y;
        victim_walldist = stats_victim.location.y - Garm.field_rect_border.y;
        dist_wallparallel = stats_victim.location.x - stats_source.location.x;
        gf_new = this.getWallGF(w, source_walldist, victim_walldist, dist, dist_wallparallel);
        if (gf_new >= 0.0) {
            gf_positive = Math.min(gf_new, gf_positive);
        } else {
            gf_negative = Math.max(gf_new, gf_negative);
        }
        source_walldist = stats_source.location.x - Garm.field_rect_border.x;
        victim_walldist = stats_victim.location.x - Garm.field_rect_border.x;
        dist_wallparallel = stats_source.location.y - stats_victim.location.y;
        gf_new = this.getWallGF(w, source_walldist, victim_walldist, dist, dist_wallparallel);
        if (gf_new >= 0.0) {
            gf_positive = Math.min(gf_new, gf_positive);
        } else {
            gf_negative = Math.max(gf_new, gf_negative);
        }
        source_walldist = Garm.field_rect_border.x + Garm.field_rect_border.width - stats_source.location.x;
        victim_walldist = Garm.field_rect_border.x + Garm.field_rect_border.width - stats_victim.location.x;
        dist_wallparallel = stats_victim.location.y - stats_source.location.y;
        gf_new = this.getWallGF(w, source_walldist, victim_walldist, dist, dist_wallparallel);
        if (gf_new >= 0.0) {
            gf_positive = Math.min(gf_new, gf_positive);
        } else {
            gf_negative = Math.max(gf_new, gf_negative);
        }
        double[] gf = new double[2];
        if (w.direction_start[0] > 0) {
            gf[0] = gf_positive;
            gf[1] = gf_negative;
        } else {
            gf[0] = -gf_negative;
            gf[1] = -gf_positive;
        }
        return gf;
    }

    private double getWallGF(BasicWave w, double source_walldist, double victim_walldist, double dist, double dist_wallparallel) {
        if (source_walldist < dist) {
            int sign = dist_wallparallel >= 0.0 ? 1 : -1;
            double angle_towall = Math.asin(source_walldist / dist) * (double)sign;
            double angle_tovictim = Math.atan((source_walldist - victim_walldist) / dist_wallparallel);
            double angle = angle_towall - angle_tovictim;
            int dir = BasicWave.getDir(angle);
            double gf_new = angle / w.gf_max_angles[0][0][dir];
            return gf_new;
        }
        return 1.1;
    }
}

