/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import rdt.Wraith.Configuration;
import rdt.Wraith.Guns.BulletClassifier;
import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.FriendlyGunSolutionComparer;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.Guns.GunComparator;
import rdt.Wraith.Guns.GunImplementations.DC.DCGun;
import rdt.Wraith.Guns.IClassifiedBulletListener;
import rdt.Wraith.Guns.IGunManager;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.IMEACalculator;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.MEA.RealWallCullingAndInterceptMEACalculator;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class FriendlyGunManager
implements IGunManager,
IWaveEventHandler,
IClassifiedBulletListener {
    private final BulletClassifier _bulletClassifier;
    private final IRobot _robot;
    private final ArrayList<Gun> _sortedGuns;
    private final GunComparator _gunComparator = new GunComparator();
    private final FiringData _firingData = new FiringData();
    private final int _firingTickOffset = -1;
    private final RobotSnapshots _targetSnapshots;
    private final FiringSolutions _firingSolutions = new FiringSolutions();
    private final FriendlyGunSolutionComparer _solutionComparer = new FriendlyGunSolutionComparer();
    private static final Random _random = new Random();
    private final MEA _mea = new MEA();
    private final IMEACalculator _meaCalculator;

    public FriendlyGunManager(String ownerName, IRobot robot, RobotSnapshots robotSnapshots, IWaveManager friendlyWaveManager, IStats stats) {
        this._robot = robot;
        this._targetSnapshots = robotSnapshots;
        String ownerNameAppended = "At " + ownerName;
        Gun[] guns = new Gun[]{new DCGun(ownerNameAppended, robot, this._targetSnapshots, stats, 0L, friendlyWaveManager, Configuration.FriendlyDCDimensionsAlt)};
        this._sortedGuns = new ArrayList(guns.length);
        this._sortedGuns.addAll(Arrays.asList(guns));
        this._bulletClassifier = new BulletClassifier(guns);
        friendlyWaveManager.RegisterWaveEventHandler(this);
        this._meaCalculator = new RealWallCullingAndInterceptMEACalculator(new FastOutsideOfBattlefield(robot, 22));
    }

    @Override
    public int PredictAngles(double originX, double originY, long tickFired, double bulletVelocity, int maxAngles, double[] anglesOut) {
        this.SortGunsByRecentHitRate();
        RobotSnapshot targetAtFiringTick = this._targetSnapshots.Read(tickFired + -1L);
        long numTicks = (long)Math.ceil(targetAtFiringTick.DistanceToItsTarget / bulletVelocity);
        this._meaCalculator.CalculateMEA(originX, originY, targetAtFiringTick, numTicks, bulletVelocity, this._mea);
        this._firingSolutions.Reset();
        this._firingData.SourceX = originX;
        this._firingData.SourceY = originY;
        this._firingData.TargetAtFiringTick = targetAtFiringTick;
        this._firingData.BulletVelocity = bulletVelocity;
        this._firingData.FiringTick = tickFired + -1L;
        this._firingData.TargetWidthRadians = Math.atan(18.0 / this._firingData.TargetAtFiringTick.DistanceToItsTarget) * 2.0;
        this._firingData.MEA.ForwardRelative = this._mea.ForwardRelative;
        this._firingData.MEA.RearRelative = this._mea.RearRelative;
        this._firingData.TargetHeadOnAbsoluteBearingAtFiringTick = MathUtils.GetAngle(originX, originY, this._firingData.TargetAtFiringTick.LocationX, this._firingData.TargetAtFiringTick.LocationY);
        for (int GunIndex = 0; GunIndex < this._sortedGuns.size(); ++GunIndex) {
            if (this._sortedGuns.get((int)GunIndex).TotalHits.Value() <= 0) continue;
            this._sortedGuns.get(GunIndex).GetFiringSolutions(this._firingData, this._firingSolutions);
        }
        if (this._firingSolutions.GetNumSolutions() <= 0) {
            anglesOut[0] = this._firingData.TargetHeadOnAbsoluteBearingAtFiringTick;
            return 1;
        }
        anglesOut[0] = this._firingSolutions.GetSolution((int)0).AbsoluteAngle;
        return 1;
    }

    @Override
    public void OnWaveGeneratedEvent() {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnWavePassed(WaveData wave, Target target) {
        if (wave.WaveType == WaveData.eWaveType.Virtual) {
            return;
        }
        RobotSnapshot targetSnapshotNow = target.RobotSnapshots.Read(this._robot.getTime());
        RobotSnapshot targetAtFiringTick = this._targetSnapshots.Read(wave.ActivationTick);
        assert (!(targetAtFiringTick.RotationDirectionToTarget >= 0.0) ? wave.MEA.ForwardRelative <= 0.0 : wave.MEA.ForwardRelative >= 0.0);
        assert (!(targetAtFiringTick.RotationDirectionToTarget >= 0.0) ? wave.MEA.RearRelative >= 0.0 : wave.MEA.RearRelative <= 0.0);
        this._firingData.SourceX = wave.OriginX;
        this._firingData.SourceY = wave.OriginY;
        this._firingData.TargetAtFiringTick = targetAtFiringTick;
        this._firingData.BulletVelocity = wave.Velocity;
        this._firingData.FiringTick = wave.ActivationTick;
        this._firingData.MEA.ForwardRelative = wave.MEA.ForwardRelative;
        this._firingData.MEA.RearRelative = wave.MEA.RearRelative;
        this._firingData.TargetWidthRadians = Math.atan(18.0 / wave.GetDistanceForTick(this._robot.getTime())) * 2.0;
        this._firingData.TargetHeadOnAbsoluteBearingAtFiringTick = MathUtils.GetAngle(wave.OriginX, wave.OriginY, this._firingData.TargetAtFiringTick.LocationX, this._firingData.TargetAtFiringTick.LocationY);
        this._bulletClassifier.Classify(targetSnapshotNow.LocationX, targetSnapshotNow.LocationY, this._firingData, this, this._firingData.TargetWidthRadians * 0.5);
    }

    @Override
    public void OnBulletClassified(Gun gun, int gunIndex, boolean hit, double deltaAngle) {
        if (hit) {
            gun.RegisterHit(deltaAngle);
        } else {
            gun.RegisterMiss(deltaAngle);
        }
    }

    @Override
    public void NoClassificationAvailable() {
    }

    private void SortGunsByRecentHitRate() {
        this._sortedGuns.sort(this._gunComparator);
    }
}

