/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.gun.gf;

import catcat20.jewel.iolite.gun.Gun;
import catcat20.jewel.iolite.gun.WaveGun;
import catcat20.jewel.iolite.knnUtils.Data;
import catcat20.jewel.iolite.knnUtils.WeightedData;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.TeamRobot;
import voidious.utils.DiaUtils;

public class SimpleGFGun
extends Gun
implements WaveGun {
    Point2D.Double myPos;
    Wave lastWave = null;
    Rectangle2D.Double rect;
    public static final int DIMENSION = 14;

    public SimpleGFGun(TeamRobot robot) {
        super(robot);
        this.rect = new Rectangle2D.Double(0.0, 0.0, robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
    }

    @Override
    public void update(Wave w) {
        this.lastWave = w;
    }

    @Override
    public void logHit(Wave w, Point2D.Double hitLocation) {
        BotState en = IoliteRadar.getEnemy(w.enemyData.name);
        if (en != null) {
            Data data = new Data();
            data.guessFactor = w.guessFactor(hitLocation);
            data.weight = 1.0;
            data.treeWeight = 1.0;
            en.putSimpleGunLog(w, data);
        }
    }

    @Override
    public double getOffset() {
        if (this.lastWave == null) {
            return 0.0;
        }
        BotState en = IoliteRadar.getEnemy(this.lastWave.enemyData.name);
        if (en != null) {
            if (en.alive) {
                Graphics2D g = this.robot.getGraphics();
                ArrayList<WeightedData<Data>> list = en.getSimpleGunNeighbors(this.lastWave);
                ArrayList<Angle> angles = new ArrayList<Angle>();
                for (WeightedData<Data> data : list) {
                    for (Data d : data.list) {
                        Angle angle = new Angle();
                        angle.angle = IUtils.limit(-1.05, d.guessFactor, 1.05) * IUtils.maxEscapeAngle(this.lastWave.bulletVelocity());
                        angle.weight = d.weight * d.treeWeight / data.list.distance();
                        angles.add(angle);
                        g.setColor(Color.gray);
                        Point2D.Double pos = IUtils.project(this.myPos, en.absBearing + angle.angle, 160.0);
                        g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)pos.x, (int)pos.y);
                    }
                }
                double bestAngle = 0.0;
                double bestDensity = 0.0;
                double bandwidth = 36.0 / this.myPos.distance(en);
                for (Angle angle : angles) {
                    double density = 0.0;
                    for (Angle angle2 : angles) {
                        if (angle == angle2) continue;
                        double ux = (angle.angle - angle2.angle) / bandwidth;
                        density += Math.exp(-0.5 * ux * ux) * angle2.weight;
                    }
                    if (!(density > bestDensity)) continue;
                    bestAngle = angle.angle;
                    bestDensity = density;
                }
                g.setColor(Color.blue);
                Point2D.Double pos = IUtils.project(this.myPos, en.absBearing + bestAngle, 230.0);
                g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)pos.x, (int)pos.y);
                g.setColor(Color.orange);
                pos = IUtils.project(this.myPos, en.absBearing, 230.0);
                g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)pos.x, (int)pos.y);
                return en.absBearing + bestAngle;
            }
            return en.absBearing;
        }
        return 0.0;
    }

    private double directToWallDistance(Wave w, boolean forward) {
        return Math.min(1.5, this.directToWallDistance(w.enemyData, w.distance(w.enemyData), w.enemyData.effectiveHeading() + (forward ? 0.0 : Math.PI), w.bulletPower));
    }

    public double directToWallDistance(Point2D.Double targetLocation, double distance, double heading, double bulletPower) {
        int bulletTicks = DiaUtils.bulletTicksFromPower(distance, bulletPower);
        double wallDistance = 2.0;
        double sinHeading = Math.sin(heading);
        double cosHeading = Math.cos(heading);
        for (int x = 0; x < 2 * bulletTicks; ++x) {
            if (this.rect.contains(targetLocation.x + sinHeading * 8.0 * (double)x, targetLocation.y + cosHeading * 8.0 * (double)x)) continue;
            wallDistance = (double)x / (double)bulletTicks;
            break;
        }
        return wallDistance;
    }

    double accelSegment(double deltaBearing, double oldDeltaBearing, double enemyDistance) {
        int delta = (int)Math.round(5.0 * enemyDistance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing)));
        if (delta < 0) {
            return -1.0;
        }
        if (delta > 0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }

    @Override
    public void onBulletHit(Wave w, BulletHitEvent e) {
    }

    @Override
    public void onBulletHitBullet(Wave w, BulletHitBulletEvent e) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public Color getColor() {
        return Color.blue;
    }

    @Override
    public String getLabel() {
        return "Simple";
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    public class Angle {
        public double angle;
        public double weight;
    }
}

