/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.radar;

import catcat20.jewel.iolite.gun.IoliteGun;
import catcat20.jewel.iolite.move.MeleeSurfing;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class IoliteRadar {
    public TeamRobot robot;
    public static HashMap<String, EnemyInfo> scans;
    public static HashMap<String, BotState> enemies;
    public boolean isMelee = false;
    public double myHeading;
    public double gunCoolingRate = 0.1;
    public double[] POWERS;
    private static final double POINTS_FOR_WIN = 100.0;
    private static final double BULLET_DAMAGE_BONUS = 0.2;
    public Rectangle2D.Double rect;
    long lastScanTime = 0L;
    EnemyInfo oldInfo = null;
    long oldInfoTryTime = 16L;
    public static BotState nearestEnemy;
    public static BotState myState;
    public static double power;
    public static double others;
    public static double energy;
    Point2D.Double myPos = new Point2D.Double(0.0, 0.0);

    public IoliteRadar(TeamRobot robot) {
        this.robot = robot;
        scans = new HashMap();
        this.rect = new Rectangle2D.Double(0.0, 0.0, robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
        this.gunCoolingRate = robot.getGunCoolingRate();
        this.POWERS = new double[59];
        for (int i = 1; i < 60; ++i) {
            this.POWERS[i - 1] = 0.05 * (double)i;
        }
        scans.clear();
        if (enemies == null) {
            enemies = new HashMap();
        } else {
            for (BotState en : enemies.values()) {
                en.init();
            }
        }
        this.myHeading = robot.getHeading();
        others = robot.getOthers();
        this.isMelee = others > 1.0;
    }

    public void execute() {
        this.myHeading = this.robot.getHeadingRadians();
        others = this.robot.getOthers();
        this.isMelee = others > 1.0;
        energy = this.robot.getEnergy();
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        this.updatePower();
        if (this.robot.getRadarTurnRemaining() == 0.0) {
            this.robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
        if (this.robot.getOthers() > 1) {
            if (this.robot.getOthers() == scans.size() && this.oldInfoTryTime < 8L && this.robot.getTime() - this.lastScanTime < 8L) {
                double angle = 0.0;
                long oldestScan = this.lastScanTime;
                EnemyInfo info = null;
                for (EnemyInfo en : scans.values()) {
                    if (en.scanTime >= oldestScan) continue;
                    angle = IUtils.absoluteBearing(this.myPos, en.pos);
                    oldestScan = en.scanTime;
                    info = en;
                }
                this.oldInfoTryTime = this.oldInfo == info ? ++this.oldInfoTryTime : 0L;
                this.oldInfo = info;
                this.robot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(angle - this.robot.getRadarHeadingRadians())) * Double.POSITIVE_INFINITY);
            } else {
                --this.oldInfoTryTime;
                this.robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
        }
        double coolingRate = this.robot.getGunCoolingRate();
        double distance = Double.POSITIVE_INFINITY;
        double vel = this.robot.getVelocity();
        for (BotState en : enemies.values()) {
            en.update((AdvancedRobot)this.robot);
            en.oldPositions.add(0, (Point2D.Double)en.clone());
            en.gunHeat -= coolingRate;
            if (!(distance > en.distance) || !en.alive || this.robot.isTeammate(en.name)) continue;
            nearestEnemy = en;
            distance = en.distance;
        }
    }

    private void updatePower() {
        if (others <= 1.0) {
            BotState en = IoliteRadar.getNearestEnemy();
            power = 1.95;
            if (en != null) {
                power = en.predictPower((AdvancedRobot)this.robot) - 0.05;
                if (en.energy <= 12.0) {
                    power = 1.65;
                }
                if (en.distance >= 650.0) {
                    power = 1.05;
                }
                if (this.robot.getEnergy() <= 8.0) {
                    power = 0.1;
                }
                if (en.distance <= 110.0) {
                    power = 3.0;
                }
                if (en.distance <= 270.0) {
                    power = 2.99999;
                }
                if (this.robot.getRoundNum() >= 3 && IoliteGun.getHighestHitRate() - MeleeSurfing.getGameHitRate() <= -2.75) {
                    power = 2.45;
                }
                if (this.robot.getRoundNum() >= 3 && MeleeSurfing.getGameHitRate() >= 15.0) {
                    power = 2.45;
                } else if (this.robot.getRoundNum() >= 3 && MeleeSurfing.getGameHitRate() >= 18.0) {
                    power = 2.9999;
                }
                if (this.robot.getRoundNum() >= 3 && IoliteGun.getHighestHitRate() >= 25.0) {
                    power = 2.45;
                } else if (this.robot.getRoundNum() >= 3 && IoliteGun.getHighestHitRate() >= 50.0) {
                    power = 2.99999;
                }
                double minimumKillPower = 0.001 + en.energy / 4.0;
                if (en.energy > 4.0) {
                    minimumKillPower = 0.001 + (en.energy + 2.0) / 6.0;
                }
                power = Math.min(minimumKillPower, power);
                power = Math.min(power, this.robot.getEnergy() - 0.15);
            }
        } else {
            power = 1.95;
            BotState en = IoliteRadar.getNearestEnemy();
            if (this.robot.getEnergy() <= 16.0) {
                power = 1.05;
            }
            if (this.robot.getEnergy() <= 8.0) {
                power = 0.1;
            }
            if (en != null) {
                if (en.distance >= 650.0) {
                    power = 1.05;
                }
                if (en.energy <= 8.0) {
                    power = en.energy / 4.0;
                }
                if (others >= 5.0) {
                    power = 2.95;
                } else if (others >= 2.0) {
                    power = 0.95 + others * 0.2;
                }
                if (en.distance <= 325.0) {
                    power = 2.999999;
                }
                if (en.distance <= 175.0) {
                    power = 3.0;
                }
            }
            power = Math.min(this.robot.getEnergy() - 0.05, power);
        }
    }

    public double choosePower() {
        if (nearestEnemy == null) {
            return 1.95;
        }
        double myEnergy = this.robot.getEnergy();
        double enEnergy = IoliteRadar.nearestEnemy.energy;
        double enPower = nearestEnemy.predictPower((AdvancedRobot)this.robot);
        double myHitRate = IoliteGun.getRealHitRate() / 100.0;
        double enHitRate = MeleeSurfing.getGameHitRate() / 100.0;
        double distance = IoliteRadar.nearestEnemy.distance;
        double bestPower = 1.95;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (double power : this.POWERS) {
            double score = this.fireScore(myEnergy, enEnergy, power, enPower, myHitRate, enHitRate, distance);
            if (!(score > bestScore)) continue;
            bestPower = power;
            bestScore = score;
        }
        if (distance < 175.0) {
            bestPower = 2.95;
        }
        double minimumKillPower = 0.001 + enEnergy / 4.0;
        if (enEnergy > 4.0) {
            minimumKillPower = 0.001 + (enEnergy + 2.0) / 6.0;
        }
        bestPower = Math.min(bestPower, minimumKillPower);
        bestPower = Math.min(bestPower, myEnergy - 0.1);
        return bestPower;
    }

    public double fireScore(double myEnergy, double enemyEnergy, double myPower, double enemyPower, double myHitRate, double enemyHitRate, double distance) {
        double winProb;
        double myScore = 0.0;
        double enScore = 0.0;
        double myCooldown = (int)((1.0 + myPower / 5.0) / this.gunCoolingRate);
        double myDamage = Rules.getBulletDamage((double)myPower) / myCooldown;
        double myGain = 3.0 * myPower / myCooldown;
        double myLoss = myPower / myCooldown;
        double enemyCooldown = (int)((1.0 + enemyPower / 5.0) / this.gunCoolingRate);
        double enemyDamage = Rules.getBulletDamage((double)enemyPower) / enemyCooldown;
        double enemyGain = 3.0 * enemyPower / enemyCooldown;
        double enemyLoss = enemyPower / enemyCooldown;
        double ticksLeft = this.getTicksLeft(myDamage, enemyDamage, myGain, enemyGain, myLoss, enemyLoss, myEnergy, enemyEnergy, myHitRate, enemyHitRate);
        double myDamageScore = myDamage * myHitRate * ticksLeft;
        double enemyDamageScore = enemyDamage * enemyHitRate * ticksLeft;
        double a = myEnergy * myDamage + enemyEnergy * myGain;
        double b = enemyEnergy * enemyDamage + myEnergy * enemyGain;
        double lambda = enemyEnergy * myLoss - myEnergy * enemyLoss - myHitRate * a + enemyHitRate * b;
        double myNeededHR = (lambda /= a * a + b * b) * a + myHitRate;
        double enemyNeededHR = -lambda * b + enemyHitRate;
        if (myNeededHR <= 0.0 || enemyNeededHR >= 1.0) {
            winProb = 1.0;
        } else if (myNeededHR >= 1.0 || enemyNeededHR <= 0.0) {
            winProb = 0.0;
        } else {
            ticksLeft = this.getTicksLeft(myDamage, enemyDamage, myGain, enemyGain, myLoss, enemyLoss, myEnergy, enemyEnergy, myNeededHR, enemyNeededHR);
            winProb = Math.sqrt((1.0 - this.probAboveHR(myNeededHR, ticksLeft, myCooldown, myHitRate)) * this.probAboveHR(enemyNeededHR, ticksLeft, enemyCooldown, enemyHitRate));
        }
        return myDamageScore - enemyDamageScore + 100.0 * winProb - 100.0 * (1.0 - winProb) + 0.2 * (IoliteGun.allHitDamage + myDamageScore) * winProb - 0.2 * (MeleeSurfing.allGetDamage + enemyDamageScore) * (1.0 - winProb);
    }

    public double probAboveHR(double targetHR, double ticks, double cooldown, double hitRate) {
        double shots = ticks / cooldown;
        double expectedHits = hitRate * shots;
        double variance = hitRate * (1.0 - hitRate) * shots;
        double targetHits = targetHR * shots;
        return IoliteRadar.phi((targetHits - expectedHits) / Math.sqrt(variance));
    }

    public static double phi(double x) {
        return (1.0 + IoliteRadar.erf(x / Math.sqrt(2.0))) / 2.0;
    }

    public static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        return z > 0.0 ? ans : -ans;
    }

    public double getTicksLeft(double myDamageRate, double enDamageRate, double myPowerGain, double enPowerGain, double myPowerLoss, double enPowerLoss, double myEnergy, double enEnergy, double myHitRate, double enemyHitRate) {
        double myCombinedLoss = Math.max(enDamageRate * enemyHitRate - myPowerGain * myHitRate + myPowerLoss, 1.0E-4);
        double enemyCombinedLoss = Math.max(myDamageRate * myHitRate - enPowerGain * enemyHitRate + enPowerLoss, 1.0E-4);
        return Math.min(myEnergy / myCombinedLoss, enEnergy / enemyCombinedLoss);
    }

    public static double calculatePower() {
        return power;
    }

    public static BotState getNearestEnemy() {
        return nearestEnemy;
    }

    private void oneRadar(ScannedRobotEvent e) {
        double angleToEnemy = this.robot.getHeadingRadians() + e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.robot.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / e.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
        radarTurn = radarTurn < 0.0 ? (radarTurn -= extraTurn) : (radarTurn += extraTurn);
        this.robot.setTurnRadarRightRadians(radarTurn);
    }

    public void updateLast() {
        this.myHeading = this.robot.getHeadingRadians();
        Graphics2D g = this.robot.getGraphics();
        g.setColor(Color.white);
        double coolingRate = this.robot.getGunCoolingRate();
        long time = this.robot.getTime();
        for (BotState en : enemies.values()) {
            double energyChange = en.energyChange;
            g.drawString("gunHeat:" + en.gunHeat, (int)en.x - 30, (int)en.y - 60);
            g.drawOval((int)en.x, (int)en.y, 5, 5);
            if (energyChange > 0.0 && energyChange < 3.01) {
                en.gunHeat = Rules.getGunHeat((double)energyChange) - coolingRate * (double)(time - en.lastLastScanTime);
            }
            en.energyChange = 0.0;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastScanTime = this.robot.getTime();
        this.myHeading = this.robot.getHeadingRadians();
        BotState en = null;
        en = enemies.get(e.getName());
        if (en == null) {
            en = new BotState(this.rect);
            enemies.put(e.getName(), en);
        }
        en.distance = e.getDistance();
        en.oldVelocity = en.velocity;
        en.velocity = e.getVelocity();
        en.oldHeading = en.heading;
        en.heading = e.getHeadingRadians();
        en.bearing = e.getBearingRadians();
        en.absBearing = e.getBearingRadians() + this.myHeading;
        en.alive = true;
        en.oldEnergy = en.energy;
        en.energy = e.getEnergy();
        en.energyChange = en.oldEnergy - en.energy;
        en.x = IUtils.project((Point2D.Double)this.myPos, (double)en.absBearing, (double)en.distance).x;
        en.y = IUtils.project((Point2D.Double)this.myPos, (double)en.absBearing, (double)en.distance).y;
        en.name = e.getName();
        en.lastLastScanTime = en.lastScanTime;
        en.lastScanTime = this.lastScanTime;
        double latVel = en.velocity * Math.sin(en.heading - en.absBearing);
        double advVel = en.velocity * -Math.cos(en.heading - en.absBearing);
        en.oldLatVel = en.latVel;
        en.latVel = latVel;
        en.oldAdvVel = en.advVel;
        en.advVel = advVel;
        EnemyInfo scan = null;
        scan = scans.get(e.getName());
        if (scan == null) {
            scan = new EnemyInfo();
            scans.put(e.getName(), scan);
        }
        scan.scanTime = this.lastScanTime;
        scan.pos = IUtils.project(this.myPos, e.getBearingRadians() + this.myHeading, e.getDistance());
        if (!this.isMelee) {
            this.oneRadar(e);
        }
    }

    public static BotState getEnemy(String name) {
        return enemies.get(name);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        scans.remove(e.getName());
        BotState en = IoliteRadar.getEnemy(e.getName());
        if (en != null) {
            en.alive = false;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        BotState en = enemies.get(e.getName());
        if (en != null) {
            en.energy += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        BotState en = enemies.get(e.getName());
        if (en != null) {
            en.energy -= Rules.getBulletDamage((double)e.getBullet().getPower());
        }
    }

    static {
        nearestEnemy = null;
        power = 1.95;
    }

    public static class EnemyInfo {
        public Point2D.Double pos;
        public long scanTime;
    }
}

