/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Enemy;
import bing2.EnemyTracker;
import bing2.MathUtils;
import bing2.MovSim;
import bing2.MovSimCallBack;
import bing2.MovSimStat;
import bing2.MovSimStg;
import bing2.Move;
import bing2.MyRobot;
import bing2.Position;
import bing2.Wave;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

public class Surfer
extends Move {
    private double _bfWidth;
    private double _bfHeight;
    private static double WALL_STICK = 140.0;
    private Rectangle2D.Double _fieldRect;
    private boolean _lastWallSmoothAway = false;
    private Rectangle2D.Double _centralRect;
    private static double SAFE_DIST = 400.0;
    private MovSim moveStatPredictor = new MovSim();
    WaveInterceptCallBack callback = new WaveInterceptCallBack();

    public Surfer(MyRobot myRobot) {
        super(myRobot);
        this._bfWidth = myRobot.getBattleFieldWidth();
        this._bfHeight = myRobot.getBattleFieldHeight();
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, this._bfWidth - 36.0, this._bfHeight - 36.0);
        this._centralRect = new Rectangle2D.Double(18.0 + WALL_STICK, 18.0 + WALL_STICK, this._bfWidth - 36.0 - 2.0 * WALL_STICK, this._bfHeight - 36.0 - 2.0 * WALL_STICK);
        this.moveStatPredictor.setCallBack(this.callback);
    }

    public void oneOnOneMove(EnemyTracker enemyTracker) {
        if (enemyTracker == null) {
            return;
        }
        Enemy enemy = enemyTracker.latest;
        Position position = enemy.getPosition();
        Position position2 = this.robot.getPosition();
        Wave wave = enemyTracker.waves.closestWave(position2);
        if (wave == null) {
            this.robot.doLog(">>>>> Wave not found", 5);
            return;
        }
        this.callback.setData(wave);
        double d = MathUtils.bearing(position2, wave.center);
        Position position3 = this.predictPosition(wave, this.robot, enemy, -1);
        Position position4 = this.predictPosition(wave, this.robot, enemy, 1);
        double d2 = enemyTracker.waves.getVisitStat(wave, position3);
        double d3 = enemyTracker.waves.getVisitStat(wave, position4);
        this.robot.doLog("danger left = " + d2, 5);
        this.robot.doLog("danger right = " + d3, 5);
        double d4 = MathUtils.distance(position2, position);
        double d5 = MathUtils.distance(position3, position) - d4;
        double d6 = MathUtils.distance(position4, position) - d4;
        double d7 = d5 < 0.0 ? Math.exp(-d5 / 50.0) : 1.0;
        double d8 = d6 < 0.0 ? Math.exp(-d6 / 50.0) : 1.0;
        double d9 = (d2 *= d7) < (d3 *= d8) ? this.getMovingAngle(position2, enemy, d - 1.5707963267948966, -1) : this.getMovingAngle(position2, enemy, d + 1.5707963267948966, 1);
        double d10 = MathUtils.normalizeTurn(d9 - this.robot.getHeadingRadians());
        int n = MathUtils.needsBack(d9 - this.robot.getHeadingRadians()) ? -1 : 1;
        this.robot.setTurnRightRadians(d10);
        this.robot.setAhead(n * 100);
    }

    public void initialMove(Position position, Wave wave) {
        int n = MyRobot.rand.nextInt(2) * 2 - 1;
        double d = MathUtils.bearing(position, wave.center) + (double)n * Math.PI / 2.0 - this.robot.getHeadingRadians();
        int n2 = MathUtils.needsBack(d) ? -1 : 1;
        this.robot.setTurnRightRadians(MathUtils.normalizeRadians(d));
        this.robot.setAhead(n2 * 100);
    }

    public void winningDance() {
        while (true) {
            this.robot.turnRight(45.0);
            this.robot.turnLeft(45.0);
        }
    }

    public double getMovingAngle(Position position, Enemy enemy, double d, int n) {
        return this.wallSmoothing(position, enemy, d, n);
    }

    public double wallSmoothing(Position position, Enemy enemy, double d, int n) {
        while (!this._fieldRect.contains(this.project(position, d, WALL_STICK))) {
            d += (double)n * 0.05;
        }
        return d;
    }

    public Position predictPosition(Wave wave, MyRobot myRobot, Enemy enemy, int n) {
        Position position = myRobot.getPosition();
        Position position2 = position.clone();
        double d = myRobot.getVelocity();
        double d2 = myRobot.getHeadingRadians();
        int n2 = 0;
        boolean bl = false;
        do {
            double d3 = this.getMovingAngle(position2, enemy, MathUtils.bearing(position2, wave.center) + (double)n * 1.5707963267948966, n) - d2;
            double d4 = 1.0;
            if (Math.cos(d3) < 0.0) {
                d3 += Math.PI;
                d4 = -1.0;
            }
            d3 = Utils.normalRelativeAngle((double)d3);
            double d5 = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(d));
            d2 = Utils.normalRelativeAngle((double)(d2 + this.limit(-d5, d3, d5)));
            d += d * d4 < 0.0 ? 2.0 * d4 : d4;
            d = this.limit(-8.0, d, 8.0);
            position2 = this.project(position2, d2, d);
            ++n2;
            if (!(position2.distance(wave.center) < wave.radius + (double)n2 * wave.velocity + wave.velocity)) continue;
            bl = true;
        } while (!bl && n2 < 500);
        return position2;
    }

    private Position project(Position position, double d, double d2) {
        return MathUtils.absolutePosition(position, d, d2);
    }

    private double limit(double d, double d2, double d3) {
        return MathUtils.limit(d2, d, d3);
    }

    private class WaveInterceptCallBack
    implements MovSimCallBack {
        private Wave w = null;
        private boolean intercepted = false;

        private WaveInterceptCallBack() {
        }

        public boolean stepPredicted(int n, MovSimStat movSimStat) {
            if (this.w == null) {
                return false;
            }
            Position position = new Position(movSimStat.x, movSimStat.y);
            if (MathUtils.distance(position, this.w.center) < this.w.radius + (double)(n + 1) * this.w.velocity + this.w.velocity) {
                this.intercepted = true;
                return false;
            }
            return true;
        }

        public MovSimStg getNewMove() {
            return null;
        }

        public void setData(Wave wave) {
            this.w = wave;
        }
    }
}

