/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.IObject;
import morbid.Utils;
import robocode.Bullet;

interface IBulletObject {

    public static class DBullet
    implements IBullet {
        private final String m_ID;
        private final Bullet m_delegate;
        private final String m_targetID;
        private final Object m_collateral;

        public final String getID() {
            return this.m_ID;
        }

        public final double getX() {
            return this.m_delegate.getX();
        }

        public final double getY() {
            return this.m_delegate.getY();
        }

        public final double[] getXY() {
            return new double[]{this.m_delegate.getX(), this.m_delegate.getY()};
        }

        public final double getHeadingRadians() {
            return this.m_delegate.getHeadingRadians();
        }

        public final double getVelocity() {
            return this.m_delegate.getVelocity();
        }

        public String getSourceID() {
            return this.m_delegate.getName();
        }

        public String getTargetID() {
            return this.m_targetID;
        }

        public String getVictimID() {
            return this.m_delegate.getVictim();
        }

        public double getPower() {
            return this.m_delegate.getPower();
        }

        public boolean isActive() {
            return this.m_delegate.isActive();
        }

        public Object getCollateral() {
            return this.m_collateral;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(this.getID());
            s.append(": ");
            s.append(Utils.printDouble(this.getX()));
            s.append('/');
            s.append(Utils.printDouble(this.getY()));
            s.append(", H ");
            s.append(Utils.printPhi(this.getHeadingRadians()));
            s.append(", V ");
            s.append(Utils.printDouble(this.getVelocity()));
            s.append(", P ");
            s.append(Utils.printDouble(this.getPower()));
            s.append('}');
            return s.toString();
        }

        DBullet(Bullet bullet, String targetID, Object collateral) {
            this.m_delegate = bullet;
            this.m_targetID = targetID;
            this.m_collateral = collateral;
            this.m_ID = Utils.getGID("DB");
        }
    }

    public static interface IBullet
    extends IObject.INamedMovingObject,
    IObject.ITransientObject {
        public String getSourceID();

        public String getTargetID();

        public String getVictimID();

        public double getPower();

        public Object getCollateral();
    }
}

