/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.components.history.History;
import bh.facade.FacadeBot;
import bh.facade.event_listeners.EventType;
import bh.facade.event_listeners.defaults.DefaultAdvancedEventListener;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public final class HistoryEventListener
extends DefaultAdvancedEventListener {
    private final History history;

    public HistoryEventListener(FacadeBot robot, History history) {
        this.history = history;
        for (EventType et : EventType.ADVANCED_EVENTS) {
            robot.registerListener(et, this);
        }
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this.history.record(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.history.record(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.history.record(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.history.record(event);
    }

    public void onCustomEvent(CustomEvent event) {
        this.history.record(event);
    }

    public void onDeath(DeathEvent event) {
        this.history.record(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.history.record(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.history.record(event);
    }

    public void onHitWall(HitWallEvent event) {
        this.history.record(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.history.record(event);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.history.record(event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.history.record(event);
        System.out.println("HistoryEventListener.onSkippedTurn(): skipped a turn");
    }

    public void onStatus(StatusEvent event) {
        this.history.record(event);
    }

    public void onWin(WinEvent event) {
        this.history.record(event);
    }
}

