/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heat
implements Continuum<Heat>,
AbsoluteToRelative<Heat, Heat> {
    private final double heat;

    public Heat(double heat) {
        assert (!Double.isNaN(heat));
        this.heat = (double)Math.round(heat * 1000000.0) / 1000000.0;
    }

    @Override
    public Heat negate() {
        return new Heat(-this.heat);
    }

    @Override
    public Heat abs() {
        return new Heat(Math.abs(this.heat));
    }

    @Override
    public Heat plus(Heat heat) {
        return new Heat(this.heat + heat.heat);
    }

    @Override
    public Heat minus(Heat heat) {
        return new Heat(this.heat - heat.heat);
    }

    @Override
    public Heat times(double d) {
        return new Heat(this.heat * d);
    }

    @Override
    public Heat divide(double d) {
        return new Heat(this.heat / d);
    }

    @Override
    public double divide(Heat heat) {
        return this.heat / heat.heat;
    }

    @Override
    public double toDouble() {
        return this.heat;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.heat)) + "h";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Heat)) {
            return false;
        }
        Heat h = (Heat)o;
        return this.heat == h.heat;
    }

    public int hashCode() {
        return new Double(this.heat).hashCode();
    }
}

