/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.gun.GunStrategy;
import cbot.cbot.gun.Move;
import cbot.cbot.gun.Pattern;

public class PatternMatcherGunStrategy
extends GunStrategy {
    public double getBulletAngel(Bot robot, Bot pray, double firePower) {
        Pattern track = pray.getPattern();
        Point roboCord = robot.getCordinate();
        Point prayCord = pray.getCordinate();
        double orgAngle = roboCord.getAngle(prayCord);
        double heading = pray.getHeading();
        double bulletVelocity = CU.getBulletVelocity(firePower);
        int index = track.getMatch();
        if (index < 1) {
            CU.log("WARNING! pattern matchet got '" + index + "' as index");
            return 0.0;
        }
        Move[] trackArray = track.getArray();
        long totTime = 0L;
        while (index < track.size() - 1) {
            Move move = trackArray[index++];
            long timeDelta = move.time - trackArray[index - 2].time;
            double BTTime = pray.getDistance() / bulletVelocity;
            if (BTTime - (double)(totTime += timeDelta) < 0.5) break;
            double velocity = move.velocity;
            double distance = velocity * (double)timeDelta;
            double headingDelta = move.headingDelta;
            heading += headingDelta;
            heading = CU.normalRelativeAngle(heading);
            prayCord.move(distance, Math.toRadians(heading));
        }
        return roboCord.getAngle(Point.putPointInValidArea(prayCord)) - orgAngle;
    }

    public boolean match(Bot pray) {
        return pray.getPattern().ready();
    }

    protected String getGunSign() {
        return "~";
    }

    public PatternMatcherGunStrategy(CBot robot) {
        super(robot);
    }
}

