/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.dsgf;

import ds.Hud;
import ds.constant.ConstantManager;
import ds.gun.dsgf.FireIndex;
import ds.gun.dsgf.IndexedVirtualBullet;
import ds.gun.dsgf.Node;
import ds.gun.dsgf.SegmentationInfo;
import java.util.Vector;

public class Tree {
    private Node m_root;
    private final int m_nbSamples;

    public Tree(int maxNodeLeafCount, int minNodeLeafCount, boolean bIsDataSaver, double decayFactor) {
        this.m_root = new Node(maxNodeLeafCount, minNodeLeafCount, bIsDataSaver, decayFactor);
        this.m_nbSamples = (int)ConstantManager.getInstance().getIntegerConstant("gun.dsgf.nbSamples").longValue();
    }

    public void add(IndexedVirtualBullet vb) {
        this.m_root.add(vb);
    }

    public double[] getSolutionSamples(SegmentationInfo si) {
        Node noeud = this.m_root.getSolutionSamples(si);
        if (noeud != null) {
            return noeud.getSamplesHitChances();
        }
        return new double[this.m_nbSamples];
    }

    public FireIndex getSolution(SegmentationInfo si) {
        return this.m_root.getSolution(si);
    }

    public void paint(Hud hud, long tick) {
        this.m_root.paint(hud, 0);
    }

    public Vector<String> getSolutionString(SegmentationInfo si) {
        return this.m_root.getSolutionString(si);
    }

    public Node getRoot() {
        return this.m_root;
    }
}

