/*
 * Decompiled with CFR 0.152.
 */
package jw;

import robocode.AdvancedRobot;

public class TurretController {
    AdvancedRobot host;

    public double bearing() {
        return this.getBearingTo(this.host.getGunHeading());
    }

    public void left(double angle) {
        this.host.setTurnGunLeft(angle);
    }

    public void right(double angle) {
        this.host.setTurnGunRight(angle);
    }

    public void toBearing(double bearing) {
        double currentBearing = this.bearing();
        if ((bearing = this.normDeg(bearing)) != currentBearing) {
            if (currentBearing > bearing) {
                if (currentBearing - bearing < 180.0) {
                    this.host.setTurnGunLeft(currentBearing - bearing);
                } else {
                    this.host.setTurnGunRight(360.0 - (currentBearing - bearing));
                }
            } else if (bearing > currentBearing) {
                if (bearing - currentBearing < 180.0) {
                    this.host.setTurnGunRight(bearing - currentBearing);
                } else {
                    this.host.setTurnGunLeft(360.0 - (bearing - currentBearing));
                }
            }
        }
    }

    public double turnRemaining() {
        return Math.abs(this.host.getGunTurnRemaining());
    }

    private final double getBearingTo(double heading) {
        return this.normDeg(heading - this.host.getHeading());
    }

    private final double normDeg(double deg) {
        if (deg < 0.0) {
            return this.normDeg(deg + 360.0);
        }
        if (deg >= 360.0) {
            return this.normDeg(deg - 360.0);
        }
        return deg;
    }

    public boolean hasTurnRemaining() {
        boolean bl = false;
        if (this.turnRemaining() != 0.0) {
            bl = true;
        }
        return bl;
    }

    public TurretController(AdvancedRobot host) {
        this.host = host;
        host.setAdjustGunForRobotTurn(true);
    }
}

