/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.movement;

import java.awt.geom.Point2D;
import rampancy.util.movement.MovSimStat;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class MovSim {
    private static final int WALL_TOLLERANCE = 16;
    private static final double systemMaxTurnRate = Math.toRadians(10.0);
    private static final double systemMaxVelocity = 8.0;
    private static final double maxBraking = 2.0;
    private static final double maxAcceleration = 1.0;
    public static final double defaultMaxTurnRate = 10.0;
    public static final double defaultMaxVelocity = 8.0;

    public static MovSimStat[] futurePos(int steps, AdvancedRobot b) {
        return MovSim.futurePos(steps, b, 8.0, 10.0);
    }

    public static MovSimStat[] futurePos(int steps, AdvancedRobot b, double maxVel, double maxTurnRate) {
        return MovSim.futurePos(steps, b.getX(), b.getY(), b.getVelocity(), maxVel, b.getHeadingRadians(), b.getDistanceRemaining(), b.getTurnRemainingRadians(), maxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
    }

    public static MovSimStat[] futurePos(int steps, Point2D.Double location, double velocity, double maxVel, double heading, double distanceRemaining, double turnRemaining, double bfWidth, double bfHeight) {
        return MovSim.futurePos(steps, location.x, location.y, velocity, maxVel, heading, distanceRemaining, turnRemaining, 10.0, bfWidth, bfHeight);
    }

    public static MovSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity, double heading, double distanceRemaining, double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {
        MovSimStat[] pos = new MovSimStat[steps];
        double acceleration = 0.0;
        boolean slowingDown = false;
        maxTurnRate = Math.toRadians(maxTurnRate);
        double moveDirection = distanceRemaining == 0.0 ? 0.0 : (distanceRemaining < 0.0 ? -1.0 : 1.0);
        int i = 0;
        while (i < steps) {
            double lastHeading = heading;
            double turnRate = Math.min(maxTurnRate, (0.4 + 0.6 * (1.0 - Math.abs(velocity) / 8.0)) * systemMaxTurnRate);
            if (angleToTurn > 0.0) {
                if (angleToTurn < turnRate) {
                    heading += angleToTurn;
                    angleToTurn = 0.0;
                } else {
                    heading += turnRate;
                    angleToTurn -= turnRate;
                }
            } else if (angleToTurn < 0.0) {
                if (angleToTurn > -turnRate) {
                    heading += angleToTurn;
                    angleToTurn = 0.0;
                } else {
                    heading -= turnRate;
                    angleToTurn += turnRate;
                }
            }
            heading = Utils.normalAbsoluteAngle((double)heading);
            if (distanceRemaining != 0.0 || velocity != 0.0) {
                if (!slowingDown && moveDirection == 0.0) {
                    slowingDown = true;
                    moveDirection = velocity > 0.0 ? 1.0 : (velocity < 0.0 ? -1.0 : 0.0);
                }
                double desiredDistanceRemaining = distanceRemaining;
                if (slowingDown) {
                    if (moveDirection == 1.0 && distanceRemaining < 0.0) {
                        desiredDistanceRemaining = 0.0;
                    } else if (moveDirection == -1.0 && distanceRemaining > 1.0) {
                        desiredDistanceRemaining = 0.0;
                    }
                }
                double slowDownVelocity = (int)(1.0 * (Math.sqrt(4.0 * Math.abs(desiredDistanceRemaining) + 1.0) - 1.0));
                if (moveDirection == -1.0) {
                    slowDownVelocity = -slowDownVelocity;
                }
                if (!slowingDown) {
                    if (moveDirection == 1.0) {
                        acceleration = velocity < 0.0 ? 2.0 : 1.0;
                        if (velocity + acceleration > slowDownVelocity) {
                            slowingDown = true;
                        }
                    } else if (moveDirection == -1.0 && velocity + (acceleration = velocity > 0.0 ? -2.0 : -1.0) < slowDownVelocity) {
                        slowingDown = true;
                    }
                }
                if (slowingDown) {
                    double perfectAccel;
                    if (distanceRemaining != 0.0 && Math.abs(velocity) <= 2.0 && Math.abs(distanceRemaining) <= 2.0) {
                        slowDownVelocity = distanceRemaining;
                    }
                    if ((perfectAccel = slowDownVelocity - velocity) > 2.0) {
                        perfectAccel = 2.0;
                    } else if (perfectAccel < -2.0) {
                        perfectAccel = -2.0;
                    }
                    acceleration = perfectAccel;
                }
                if (velocity > maxVelocity || velocity < -maxVelocity) {
                    acceleration = 0.0;
                }
                if ((velocity += acceleration) > maxVelocity) {
                    velocity -= Math.min(2.0, velocity - maxVelocity);
                }
                if (velocity < -maxVelocity) {
                    velocity += Math.min(2.0, -velocity - maxVelocity);
                }
                double dx = velocity * Math.sin(heading);
                double dy = velocity * Math.cos(heading);
                x += dx;
                y += dy;
                if (slowingDown && velocity == 0.0) {
                    distanceRemaining = 0.0;
                    moveDirection = 0.0;
                    slowingDown = false;
                    acceleration = 0.0;
                }
                distanceRemaining -= velocity;
                if (x < 16.0 || y < 16.0 || x > battleFieldW - 16.0 || y > battleFieldH - 16.0) {
                    distanceRemaining = 0.0;
                    angleToTurn = 0.0;
                    velocity = 0.0;
                    moveDirection = 0.0;
                    x = Math.max(16.0, Math.min(battleFieldW - 16.0, x));
                    y = Math.max(16.0, Math.min(battleFieldH - 16.0, y));
                }
            }
            pos[i] = new MovSimStat(x, y, velocity, heading, Utils.normalRelativeAngle((double)(heading - lastHeading)));
            ++i;
        }
        return pos;
    }
}

