/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.ArrayList;
import java.util.List;
import pa3k.AngleUtils;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.State;
import robocode.util.Utils;

class Simulation {
    protected List<State> states;
    protected List<Position> position;
    protected List<Boolean> dirChange;
    protected long startTime;
    private double heading;
    private double lastHeading;
    private int direction;
    private long lastOpponentSpeedChange;
    private long lastOpponentHitDelay;
    private long lastEnergyDropDelay;
    private double lastEnergyDrop;

    public Simulation(State[] states, State currentState, long startTime, double bulletSpeed, Position my, Opponent target) {
        block2: {
            this.states = new ArrayList<State>(15);
            this.position = new ArrayList<Position>(15);
            this.dirChange = new ArrayList<Boolean>(15);
            Position p = target.getLastPosition();
            Log.log(4, "" + p);
            p.check();
            this.position.add(new Position(p));
            this.states.add(currentState);
            this.dirChange.add(false);
            this.startTime = startTime;
            this.direction = target.getLastVelocity() > 0.0 ? 1 : -1;
            this.lastOpponentSpeedChange = target.getLastSpeedChange(startTime);
            this.lastEnergyDropDelay = -1L;
            this.lastOpponentHitDelay = 0L;
            this.lastEnergyDrop = 0.0;
            this.heading = 0.0;
            this.lastHeading = 0.0;
            try {
                this.heading = target.getLastHeading(startTime);
                this.lastHeading = target.getLastHeading(startTime - 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.simulateUntilHit(states, 0, bulletSpeed, my, target);
    }

    public boolean isStillValid(long now, State s, boolean dirCh) {
        int idx = (int)(now - this.startTime);
        if (idx > 5) {
            return false;
        }
        if (idx >= this.states.size()) {
            return true;
        }
        return this.states.get(idx) == s && this.dirChange.get(idx) == dirCh;
    }

    public Position expectedPosition(State[] states, long now, double bulletSpeed, Position my, Opponent target) {
        int turns = 0;
        int phaseOffset = (int)(now - this.startTime);
        Position p = this.position.get(turns);
        while (p.distance(my) > bulletSpeed * (double)(turns - phaseOffset)) {
            if (++turns >= this.position.size()) {
                this.simulateUntilHit(states, phaseOffset, bulletSpeed, my, target);
            }
            p = this.position.get(turns);
        }
        return p;
    }

    private void simulateUntilHit(State[] states, int phaseOffset, double bulletSpeed, Position my, Opponent target) {
        int turns = this.position.size() - 1;
        Position p = new Position(this.position.get(turns));
        State s = this.states.get(turns);
        while (p.distance(my) > bulletSpeed * (double)(turns - phaseOffset)) {
            double nHeading = s.advancePosition(p, this.heading, this.lastHeading, this.direction);
            this.lastHeading = this.heading;
            this.heading = nHeading;
            Position f = new Position(p);
            f.modify(1L, 140 * this.direction, this.heading);
            boolean facingWall = !f.isInBattlefield();
            Change c = s.advance(p, this.lastOpponentSpeedChange, facingWall, this.lastOpponentHitDelay, this.lastEnergyDropDelay, this.lastEnergyDrop);
            boolean dirCh = false;
            if (c != null) {
                s = c.getTargetState();
                if (c.isChangingDirection()) {
                    this.direction *= -1;
                    this.lastHeading = Utils.normalAbsoluteAngle((double)(this.lastHeading + 2.0 * AngleUtils.difference(this.heading, this.lastHeading)));
                    dirCh = true;
                }
            }
            ++turns;
            ++this.lastOpponentSpeedChange;
            ++this.lastOpponentHitDelay;
            ++this.lastEnergyDropDelay;
            this.position.add(new Position(p));
            this.states.add(s);
            this.dirChange.add(dirCh);
        }
    }
}

