/*
 * Decompiled with CFR 0.152.
 */
package ary;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Help
extends AdvancedRobot {
    private static double[][][] _surfStats = new double[4][5][47];
    public static Point2D.Double _myLocation;
    public static Point2D.Double _enemyLocation;
    public static LinkedList _enemyWaves;
    private static double _oppEnergy;
    private static Wave _surfWave;
    private static Wave _nextSurfWave;
    private static double _lastDistance;
    private static double _lastLatVel;
    private static double _lastAbsBearingRadians;
    private static double _goAngle;
    private static int stopgo;
    private static Rectangle2D.Double _fieldRect;
    static final double A_LITTLE_LESS_THAN_HALF_PI = 1.25;
    static final double WALL_STICK = 160.0;
    static final int GF_ZERO = 23;
    static final int GF_ONE = 46;
    private static double _enemyAbsoluteBearing;
    private static double enDis;
    private static int _lastGunOrientation;
    static double lastVChangeTime;
    static int enemyVelocity;
    static double[][][][][][] _gunStats;
    static final double LOG_BASE_E_TO_2_CONVERSION_CONSTANT = 1.4427;

    public void run() {
        this.setColors(Color.blue, Color.cyan, Color.white);
        _enemyWaves = new LinkedList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsoluteBearing;
        int direction;
        Wave w;
        double d;
        double bulletPower = _oppEnergy - e.getEnergy();
        if (d <= (double)3 && bulletPower > 0.0) {
            w = _nextSurfWave;
            _nextSurfWave.bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
            this.addCustomEvent(w);
            _enemyWaves.addLast(w);
        }
        _nextSurfWave = w = new Wave();
        w.directAngle = _lastAbsBearingRadians;
        w.waveGuessFactors = _surfStats[(int)Math.min((_lastDistance + 50.0) / 200.0, (double)3)][(int)((Math.abs(_lastLatVel) + 1.0) / (double)2)];
        w.orientation = direction = Help.sign(_lastLatVel);
        _myLocation = new Point2D.Double(this.getX(), this.getY());
        _enemyAbsoluteBearing = enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        _lastDistance = enDis = e.getDistance();
        w.sourceLocation = _enemyLocation = Help.project(_myLocation, enemyAbsoluteBearing, enDis);
        w = new Wave();
        new Wave().sourceLocation = _myLocation;
        this.addCustomEvent(w);
        if (this.getOthers() == 1) {
            w.directAngle = enemyAbsoluteBearing;
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(w.directAngle - this.getRadarHeadingRadians())) * (double)2);
        } else {
            w.directAngle = enemyAbsoluteBearing;
        }
        try {
            _surfWave = (Wave)((Object)_enemyWaves.getFirst());
            direction = Help.sign(this.checkDanger(-1) - this.checkDanger(1));
            _goAngle = _surfWave.absoluteBearing(_myLocation) + 1.25 * (double)direction;
        }
        catch (Exception angle) {
            // empty catch block
        }
        double angle = Help.wallSmoothing(_myLocation, _goAngle, direction) - this.getHeadingRadians();
        this.setTurnRightRadians(Math.tan(angle));
        if (Math.abs(Math.cos(angle)) > (double)2) {
            stopgo = 0;
        }
        this.setAhead(Math.cos(angle) * 100.0 * (double)stopgo);
        stopgo = 1;
        double enemyLatVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        _lastGunOrientation = w.orientation = Help.sign(enemyLatVel);
        double d2 = lastVChangeTime;
        lastVChangeTime = d2 + 1.0;
        int bestGF = Math.min(3, (int)Math.pow(280.0 * d2 / _lastDistance, 0.7));
        enemyLatVel = Math.abs(enemyLatVel);
        int newVelocity = (int)enemyLatVel;
        if (enemyVelocity != newVelocity) {
            lastVChangeTime = 0.0;
            bestGF = 4;
            if (enemyVelocity > newVelocity) {
                bestGF = 3;
            }
        }
        enemyVelocity = newVelocity;
        double[][][][] dArray = _gunStats[bestGF][(int)(1.4427 * Math.log(enemyLatVel + 1.5))];
        int n = 0;
        if (Help.gunWallDistance(0.18247367367)) {
            n = 1;
            if (Help.gunWallDistance(0.36494734735)) {
                n = Help.gunWallDistance(0.63865785787) + 2;
            }
        }
        w.waveGuessFactors = dArray[n][1 - Help.gunWallDistance(-0.36494734735)][(int)Help.limit(0.0, (_lastDistance - 75.0) / 200.0, 2)];
        bestGF = 23;
        int gf = 46;
        while (gf >= 0 && (_oppEnergy = e.getEnergy()) > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        double power = Math.min(e.getEnergy() / (double)2, (double)2 - Math.max(0.0, (30.0 - this.getEnergy()) / 16.0));
        w.bulletSpeed = Rules.getBulletSpeed((double)power);
        w.distance = -1.5 * w.bulletSpeed;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + (double)_lastGunOrientation * (Math.asin(8.0 / w.bulletSpeed) / 23.0) * (double)(bestGF - 23))));
        if (this.getOthers() > 1 && this.getGunHeat() < 1.0) {
            this.setTurnRadarLeft(this.getRadarTurnRemaining());
        }
        if (Math.abs(this.getGunTurnRemaining()) < (double)3) {
            int n2 = 0;
            if (enDis > 150.0) {
                n2 = 1;
            }
            if (this.setFireBullet(power + (double)(1 - n2)) != null) {
                w.weight = 4;
            }
        }
        _lastLatVel = this.getVelocity() * Math.sin(e.getBearingRadians());
        _goAngle = _lastAbsBearingRadians = enemyAbsoluteBearing + Math.PI;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Wave surfWave = _surfWave;
        _oppEnergy += e.getBullet().getPower() * (double)3;
        if (surfWave.distanceToPoint(_myLocation) - surfWave.distance < 100.0) {
            Help.logHit(surfWave, _myLocation, 0.7);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double bulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        int x = 0;
        while (x < _enemyWaves.size()) {
            Wave w = (Wave)((Object)_enemyWaves.get(x));
            if (Math.abs(w.distanceToPoint(bulletLocation) - w.distance) < 50.0) {
                Help.logHit(w, bulletLocation, 0.7);
            }
            ++x;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        _oppEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onCustomEvent(CustomEvent e) {
        this.removeCustomEvent(e.getCondition());
    }

    public static void logHit(Wave w, Point2D.Double targetLocation, double rollingDepth) {
        int x = 46;
        while (x >= 0) {
            w.waveGuessFactors[x] = (w.waveGuessFactors[x] * rollingDepth + (double)(1 + w.weight) / (Math.pow(x - Help.getFactorIndex(w, targetLocation), 2) + 1.0)) / (rollingDepth + 1.0 + (double)w.weight);
            --x;
        }
    }

    private static final int getFactorIndex(Wave w, Point2D.Double botLocation) {
        return (int)Help.limit(0.0, Utils.normalRelativeAngle((double)(w.absoluteBearing(botLocation) - w.directAngle)) * (double)w.orientation / Math.asin(8.0 / w.bulletSpeed) * 23.0 + 23.0, 46.0);
    }

    private final double checkDanger(int direction) {
        double moveDir;
        double moveAngle;
        double maxTurning;
        double lastPredictedDistance;
        Wave surfWave = _surfWave;
        Point2D.Double predictedPosition = _myLocation;
        double predictedHeading = this.getHeadingRadians();
        double predictedVelocity = this.getVelocity();
        int counter = 3;
        do {
            double d;
            moveDir = 1.0;
            moveAngle = Help.wallSmoothing(predictedPosition, surfWave.absoluteBearing(predictedPosition) + (double)direction * 1.25, direction) - predictedHeading;
            if (!(Math.cos(d) < 0.0)) continue;
            moveAngle += Math.PI;
            moveDir = -1.0;
        } while ((lastPredictedDistance = surfWave.distanceToPoint(predictedPosition = Help.project(predictedPosition, predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Help.limit(-(maxTurning = Rules.getTurnRateRadians((double)Math.abs(predictedVelocity))), Utils.normalRelativeAngle((double)moveAngle), maxTurning))), predictedVelocity = Help.limit(-8.0, predictedVelocity + (predictedVelocity * moveDir < 0.0 ? (double)2 * moveDir : moveDir), 8.0)))) >= surfWave.distance + (double)(++counter) * surfWave.bulletSpeed);
        int index = Help.getFactorIndex(surfWave, predictedPosition);
        return (surfWave.waveGuessFactors[index] + 0.01 / (double)(Math.abs(index - 23) + 1)) / Math.pow(lastPredictedDistance, 4);
    }

    private static final double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    private static final Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    private static final int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    private static final double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(Help.project(botLocation, angle, 160.0))) {
            if (enDis > 250.0) {
                angle += (double)orientation * 0.05;
                continue;
            }
            angle -= (double)orientation * 0.05;
        }
        return angle;
    }

    private static final boolean gunWallDistance(double wallDistance) {
        return _fieldRect.contains(Help.project(_myLocation, _enemyAbsoluteBearing + (double)_lastGunOrientation * wallDistance, _lastDistance));
    }

    static {
        stopgo = 1;
        _fieldRect = new Rectangle2D.Double(22.0, 22.0, 756.0, 556.0);
        _gunStats = new double[6][4][4][2][3][47];
    }

    static class Wave
    extends Condition {
        Point2D.Double sourceLocation;
        double[] waveGuessFactors;
        double bulletSpeed;
        double directAngle;
        double distance;
        int orientation;
        int weight;

        public double distanceToPoint(Point2D.Double p) {
            return this.sourceLocation.distance(p);
        }

        public double absoluteBearing(Point2D.Double target) {
            return Math.atan2(target.x - this.sourceLocation.x, target.y - this.sourceLocation.y);
        }

        public boolean test() {
            double d;
            Point2D.Double double_ = _enemyWaves.contains((Object)this) ? _myLocation : _enemyLocation;
            this.distance += this.bulletSpeed;
            if (this.distanceToPoint(double_) <= d + (double)2 * this.bulletSpeed) {
                if (!_enemyWaves.remove((Object)this)) {
                    Help.logHit(this, _enemyLocation, 600.0);
                }
                return true;
            }
            return false;
        }

        Wave() {
        }
    }
}

