/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.text.NumberFormat;
import taqho.Heading;
import taqho.MathUtils;

public class Location {
    protected static final int SAME_LOCATION = 0;
    protected static final int TOP_RIGHT = 1;
    protected static final int BOTTOM_RIGHT = 2;
    protected static final int BOTTOM_LEFT = 3;
    protected static final int TOP_LEFT = 4;
    private double mX = 0.0;
    private double mY = 0.0;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public Location() {
        this.Initialise();
    }

    public Location(double xPos, double yPos) {
        this.Initialise();
        this.mX = xPos;
        this.mY = yPos;
    }

    public Location(Location locn) {
        this.Initialise();
        this.Set(locn);
    }

    public void Initialise() {
        this.mX = 0.0;
        this.mY = 0.0;
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void Set(Location newLocn) {
        if (newLocn != null) {
            this.mX = newLocn.GetX();
            this.mY = newLocn.GetY();
        }
    }

    public void Set(double newX, double newY) {
        this.mX = newX;
        this.mY = newY;
    }

    public void SetX(double newX) {
        this.mX = newX;
    }

    public void SetY(double newY) {
        this.mY = newY;
    }

    public void ChangeX(double deltaX) {
        this.mX += deltaX;
    }

    public void ChangeY(double deltaY) {
        this.mY += deltaY;
    }

    public double GetX() {
        return this.mX;
    }

    public double GetY() {
        return this.mY;
    }

    protected Location minus(Location loc2) {
        return new Location(Math.abs(this.mX - loc2.GetX()), Math.abs(this.mY - loc2.GetY()));
    }

    public double DistanceTo(Location toLocn) {
        double answer = -1.0;
        double fromX = this.mX;
        double fromY = this.mY;
        double toX = toLocn.GetX();
        double toY = toLocn.GetY();
        double deltaX = toX - fromX;
        double deltaY = toY - fromY;
        double targetDist2 = deltaX * deltaX + deltaY * deltaY;
        answer = Math.sqrt(targetDist2);
        return answer;
    }

    public void SetRelative(Location sourceLocn, Heading heading, double distance) {
        double h = heading.Get();
        this.mX = sourceLocn.GetX() + distance * MathUtils.sin(h);
        this.mY = sourceLocn.GetY() + distance * MathUtils.cos(h);
    }

    public void SetRelative(double x, double y, Heading heading, double distance) {
        this.SetRelative(new Location(x, y), heading, distance);
    }

    protected double headingTo(Location loc) {
        Location diff = loc.minus(this);
        int direction = this.getQuadrant(loc);
        double angle = Math.toDegrees(Math.atan(diff.GetY() / diff.GetX()));
        double bearing = 0.0;
        if (direction == 1) {
            bearing = 90.0 - angle;
        }
        if (direction == 2) {
            bearing = 90.0 + angle;
        }
        if (direction == 3) {
            bearing = 270.0 - angle;
        }
        if (direction == 4) {
            bearing = 270.0 + angle;
        }
        bearing = MathUtils.reduceTo0to360(bearing);
        return bearing;
    }

    protected int getQuadrant(Location loc) {
        if (this.mX <= loc.GetX() && this.mY <= loc.GetY()) {
            return 1;
        }
        if (this.mX <= loc.GetX() && this.mY > loc.GetY()) {
            return 2;
        }
        if (this.mX >= loc.GetX() && this.mY > loc.GetY()) {
            return 3;
        }
        if (this.mX >= loc.GetX() && this.mY <= loc.GetY()) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        String answer = new String();
        answer = answer.concat("[");
        answer = answer.concat(this.dp2.format(this.mX));
        answer = answer.concat(",");
        answer = answer.concat(this.dp2.format(this.mY));
        answer = answer.concat("]");
        return answer;
    }

    public void Print() {
        System.out.print("[" + this.dp2.format(this.mX) + "," + this.dp2.format(this.mY) + "]");
    }
}

