/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Position;
import java.io.PrintStream;

public class Force {
    double vx;
    double vy;

    public Force() {
        this.vx = 0.0;
        this.vy = 0.0;
    }

    public void setForce(double d, double d2) {
        this.vx = Math.sin(d) * d2;
        this.vy = Math.cos(d) * d2;
    }

    public Force(Position position, Position position2, double d) {
        double d2 = position2.bearing(position);
        this.vx = Math.sin(d2) * d;
        this.vy = Math.cos(d2) * d;
    }

    public void setForce(Position position, Position position2, double d) {
        double d2 = position2.bearing(position);
        this.vx = Math.sin(d2) * d;
        this.vy = Math.cos(d2) * d;
    }

    public void setForce(Position position, Position position2, double d, double d2) {
        double d3 = position2.bearing(position);
        this.vx = Math.sin(d3 + d2) * d;
        this.vy = Math.cos(d3 + d2) * d;
    }

    public void add(Force force) {
        this.vx += force.vx;
        this.vy += force.vy;
    }

    public void dump(PrintStream printStream) {
        printStream.print("(" + this.vx + "," + this.vy + ") " + this.bearing() + " : ");
        printStream.println(Math.round(this.bearing() / (Math.PI * 2) * 360.0));
    }

    public double bearing() {
        double d = Math.atan2(this.vx, this.vy);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public double strength() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void swap() {
        double d = this.vx;
        this.vx = this.vy;
        this.vy = d;
    }

    public void rotate(double d) {
        double d2 = this.bearing();
        double d3 = this.strength();
        this.vx = Math.sin(d2 += d) * d3;
        this.vy = Math.cos(d2) * d3;
    }
}

