/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.gun;

import eem.frame.bot.fighterBot;
import eem.frame.gun.firingSolution;
import eem.frame.gun.gunManager;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import eem.frame.misc.profiler;
import eem.frame.wave.wave;
import eem.frame.wave.waveWithBullets;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import robocode.Rules;

public class masterBotGunManager
extends gunManager {
    public masterBotGunManager() {
    }

    public masterBotGunManager(fighterBot fighterBot2) {
        this();
        this.myBot = fighterBot2;
    }

    public void askRadarToTrack() {
        if (this.myBot.proxy.getGunHeat() / physics.gunCoolingRate - 1.0 < 4.0) {
            this.myBot.getRadar().setNeedToTrackTarget(true);
        } else {
            this.myBot.getRadar().setNeedToTrackTarget(false);
        }
    }

    public void fireTheGunIfShould() {
        if (this.myBot.getTime() == this.fireAtTime && this.myBot.proxy.getGunTurnRemaining() == 0.0 && this.myBot.proxy.getGunHeat() == 0.0) {
            this.myBot.proxy.setFireBullet(this.bestFiringSolution.bulletEnergy);
            this.firedAt.incrHashCounter(this.targetBot.getName());
            wave wave2 = new wave(this.myBot.getInfoBot(), this.myBot.getTime(), this.bestFiringSolution.bulletEnergy);
            this.myBot.getGameInfo()._wavesManager.add(wave2);
            waveWithBullets waveWithBullets2 = new waveWithBullets(wave2);
            for (firingSolution firingSolution2 : this.firingSolutions) {
                waveWithBullets2.addFiringSolution(firingSolution2);
            }
            this.myBot.myWaves.add(waveWithBullets2);
        }
    }

    public void aimTheGun() {
        if (this.myBot.proxy.getGunHeat() / physics.gunCoolingRate > 10.0) {
            return;
        }
        this.firingSolutions = new LinkedList();
        LinkedList<firingSolution> linkedList = new LinkedList();
        double d = -1000.0;
        if (this.targetBot != null) {
            d = this.bulletEnergyVsDistance(this.targetBot);
            if (d >= this.myBot.getEnergy() - 1.0E-4) {
                return;
            }
            if ((d = Math.max(d, 0.0)) <= 0.0) {
                return;
            }
            linkedList = this.getFiringSolutions(this.targetBot, this.myBot.getTime() + 1L, d);
            this.firingSolutions.addAll(linkedList);
            firingSolution firingSolution2 = this.getTheBestFiringSolution(linkedList);
            if (firingSolution2 == null) {
                logger.noise("time " + this.myBot.getTime() + " Veto on fire: no firing solution");
                return;
            }
            if (this.isBulletShieldDetected(this.targetBot.getName())) {
                double d2 = 1.0;
                double d3 = d2 * (double)math.signNoZero(Math.random() - 0.5);
                firingSolution2.offsetFiringAngle(d3);
            }
            this.aimAndSetGun(firingSolution2);
            if (this.myBot.getGameInfo().getNumEnemyAlive() <= 4) {
                for (fighterBot fighterBot2 : this.myBot.getEnemyBots()) {
                    if (fighterBot2.getName().equals(this.targetBot.getName())) continue;
                    linkedList = this.getFiringSolutions(fighterBot2, this.myBot.getTime() + 1L, d);
                    this.firingSolutions.addAll(linkedList);
                }
            }
        }
    }

    @Override
    public void manage() {
        profiler.start("gunManagerManage");
        this.askRadarToTrack();
        this.fireTheGunIfShould();
        this.targetBot = this.findTheBestTarget();
        this.aimTheGun();
        profiler.stop("gunManagerManage");
    }

    protected double bulletEnergyVsDistance(fighterBot fighterBot2) {
        double d = this.myBot.getPosition().distance(fighterBot2.getPosition());
        double d2 = Math.min(500.0 / d, 3.0);
        d2 = Math.min(d2, physics.minReqBulEnergyToKillTarget(fighterBot2.getEnergy()));
        d2 = Math.max(d2, 0.1);
        return d2;
    }

    public void aimAndSetGun(firingSolution firingSolution2) {
        if (firingSolution2 == null) {
            this.bestFiringSolution = null;
            return;
        }
        if (firingSolution2.getQualityOfSolution() < this.firingSolutionQualityThreshold) {
            logger.noise("time " + this.myBot.getTime() + " bad firing solution. Veto on firing gun " + firingSolution2.getGunName());
            return;
        }
        logger.noise("time " + this.myBot.getTime() + " firing solution is good");
        double d = firingSolution2.bulletEnergy;
        double d2 = firingSolution2.firingAngle;
        double d3 = this.myBot.proxy.getGunHeading();
        double d4 = math.shortest_arc(d2 - d3);
        this.myBot.proxy.setTurnGunRight(d4);
        this.fireAtTime = this.myBot.getTime() + 1L;
        this.bestFiringSolution = firingSolution2;
    }

    public fighterBot findTheBestTarget() {
        fighterBot fighterBot2 = null;
        if (this.myBot.getEnemyBots().size() == 0) {
            return null;
        }
        double d = -1000000.0;
        double d2 = 1.0;
        for (fighterBot fighterBot3 : this.myBot.getEnemyBots()) {
            d2 = 1.0;
            d2 *= this.botTargetingWeightByDistance(fighterBot3);
            if ((d2 *= this.botTargetingWeightByScanLag(fighterBot3)) >= 1.0) {
                fighterBot2 = fighterBot3;
                break;
            }
            d2 *= this.botTargetingWeightByEnemyEnergy(fighterBot3);
            int n = 4;
            if (this.myBot.getGameInfo().getRoundNum() > (long)n) {
                d2 *= this.botTargetingWeightByFiredShots(fighterBot3);
                d2 *= this.botTargetingWeightByHitRate(fighterBot3);
            }
            if (!(d2 > d)) continue;
            d = d2;
            fighterBot2 = fighterBot3;
        }
        this.reportBestTargetBot(fighterBot2);
        return fighterBot2;
    }

    public void reportBestTargetBot(fighterBot fighterBot2) {
        if (fighterBot2 != null) {
            if (this.targetBot != null) {
                if (!this.targetBot.getName().equals(fighterBot2.getName())) {
                    logger.routine("" + this.myBot.getTime() + " best target " + fighterBot2.getName());
                }
            } else {
                logger.routine("" + this.myBot.getTime() + " best target " + fighterBot2.getName());
            }
        }
    }

    public double botTargetingWeightByFireAngleSpread(fighterBot fighterBot2) {
        double d = 1.0;
        long l = this.myBot.getTime() + 1L;
        String string = fighterBot2.getName();
        Point2D.Double double_ = this.myBot.getMotion().getPositionAtTime(l);
        Point2D.Double double_2 = fighterBot2.getMotion().getPositionAtTime(l);
        double d2 = math.angle2pt(double_, double_2);
        LinkedList<Double> linkedList = new LinkedList<Double>();
        int n = 0;
        for (fighterBot fighterBot3 : this.myBot.getEnemyBots()) {
            if (fighterBot3.getName().equals(string)) continue;
            ++n;
            double_2 = fighterBot3.getMotion().getPositionAtTime(l);
            double d3 = math.angle2pt(double_, double_2) - d2;
            d3 = math.shortest_arc(d3);
            linkedList.add(d3);
        }
        if (n <= 2) {
            return 1.0;
        }
        double d4 = 0.0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            double d5 = (Double)iterator.next();
            d4 += d5;
        }
        d4 /= (double)n;
        double d6 = 0.0;
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            double d7 = (Double)iterator2.next();
            d6 += d7 * d7;
        }
        double d8 = Math.sqrt(d6 /= (double)n);
        double d9 = 60.0;
        double d10 = 0.2;
        d = Math.exp(-d8 / d9);
        d = 1.0 - d10 + d10 * d;
        return d;
    }

    public double botTargetingWeightByHitRate(fighterBot fighterBot2) {
        double d = 1.0;
        d = math.eventRate(this.hitByMe.getHashCounter(fighterBot2.getName()).intValue(), this.firedAt.getHashCounter(fighterBot2.getName()).intValue());
        double d2 = 0.2;
        d = 1.0 - d2 + d2 * d;
        return d;
    }

    public double botTargetingWeightByEnemyEnergy(fighterBot fighterBot2) {
        double d = 1.0;
        double d2 = fighterBot2.getEnergy();
        d = 1.0 - Math.tanh(d2 / 50.0);
        double d3 = 0.2;
        d = 1.0 - d3 + d3 * d;
        return d;
    }

    public double botTargetingWeightByFiredShots(fighterBot fighterBot2) {
        double d = 1.0;
        double d2 = this.firedAt.getHashCounter(fighterBot2.getName()).intValue();
        d = Math.exp(-d2 / 40.0);
        return d;
    }

    public double botTargetingHitProbWeight(fighterBot fighterBot2) {
        double d = 1.0;
        d *= this.botTargetingWeightByDistance(fighterBot2);
        int n = 4;
        if (this.myBot.getGameInfo().getRoundNum() > (long)n) {
            double d2 = math.eventRate(this.hitByMe.getHashCounter(fighterBot2.getName()).intValue(), this.firedAt.getHashCounter(fighterBot2.getName()).intValue());
            d = Math.max(d, d2);
        }
        return d;
    }

    public double botTargetingWeightByDistance(fighterBot fighterBot2) {
        double d = 1.0;
        double d2 = this.myBot.getPosition().distance(fighterBot2.getPosition());
        double d3 = Rules.getBulletSpeed((double)3.0);
        double d4 = d2 / d3;
        double d5 = 16.0 * d4;
        d = (double)(2 * physics.robotHalfSize) / d5;
        return d;
    }

    public double botTargetingWeightByScanLag(fighterBot fighterBot2) {
        long l = 9L;
        double d = Math.exp(-(this.myBot.getTime() - fighterBot2.getLastSeenTime()) / (3L * l));
        return d;
    }

    public fighterBot findTheClosestTargetWithSwitchTrechold() {
        double d = 100.0;
        long l = 9L;
        if (this.myBot.getEnemyBots().size() == 0) {
            return null;
        }
        double d2 = 1000000.0;
        if (this.targetBot != null && this.myBot.getTime() - this.targetBot.getLastSeenTime() < l) {
            d2 = this.myBot.getPosition().distance(this.targetBot.getPosition());
        }
        for (fighterBot fighterBot2 : this.myBot.getEnemyBots()) {
            double d3 = this.myBot.getPosition().distance(fighterBot2.getPosition());
            if (!(d3 + d < d2) || this.myBot.getTime() - fighterBot2.getLastSeenTime() >= l) continue;
            d2 = d3;
            this.targetBot = fighterBot2;
        }
        return this.targetBot;
    }

    public firingSolution getTheBestFiringSolution(LinkedList<firingSolution> linkedList) {
        firingSolution firingSolution2 = null;
        double d = -1000.0;
        for (firingSolution firingSolution3 : linkedList) {
            if (!(firingSolution3.getQualityOfSolution() > d)) continue;
            firingSolution2 = firingSolution3;
            d = firingSolution3.getQualityOfSolution();
        }
        return firingSolution2;
    }
}

