/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800;

import fowl3628800.Enemy;
import fowl3628800.EnemyCollection;
import fowl3628800.EnemyImpl;
import fowl3628800.ModularBot;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import robocode.ScannedRobotEvent;

public class EnemyManager {
    private static EnemyManager SINGLETON = new EnemyManager();
    private Map m_allInformation = new Hashtable();

    private EnemyManager() {
    }

    public static EnemyManager getInstance() {
        return SINGLETON;
    }

    public Enemy log(ScannedRobotEvent in_event, ModularBot bot) {
        String name = in_event.getName();
        EnemyCollection col = (EnemyCollection)this.m_allInformation.get(name);
        Enemy newEnemy = EnemyImpl.createEnemy(in_event, bot, col);
        if (col == null) {
            col = new EnemyCollection(newEnemy);
            this.m_allInformation.put(newEnemy.getName(), col);
        } else {
            col.add(newEnemy);
        }
        return col;
    }

    public Enemy get(String in_name) {
        return (Enemy)this.m_allInformation.get(in_name);
    }

    public Enemy get(String in_name, int in_time) {
        EnemyCollection col = (EnemyCollection)this.m_allInformation.get(in_name);
        return col == null ? null : col.get(in_time);
    }

    public static final int getCacheSize() {
        return 500;
    }

    public int getMapSize() {
        return this.m_allInformation.size();
    }

    public Iterator getMapIterator() {
        return this.m_allInformation.values().iterator();
    }

    public Map getMap() {
        return this.m_allInformation;
    }
}

