/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns.DC;

import java.util.ArrayList;
import rdt.KDTree.KDTree;
import rdt.Utils.MaximumEscapeAngle;
import rdt.VirtualGuns.Guns.DC.DCHit;
import rdt.VirtualGuns.Guns.DC.KernelDensityBase;

public class KernelDensityUniform
extends KernelDensityBase {
    @Override
    public double GetBestGuessFactor(ArrayList<KDTree.SearchResult<DCHit>> results, double distanceToTarget, MaximumEscapeAngle mea) {
        double botWidthAngle = this.GetBotWidthAngle(distanceToTarget);
        double oneOverBotWidthAngle = 1.0 / botWidthAngle;
        double bestDensity = 0.0;
        double bestGuessFactor = 0.0;
        int numResults = results.size();
        int resultToCheck = 0;
        while (resultToCheck < numResults) {
            double density = 0.0;
            double guessFactor = ((DCHit)results.get((int)resultToCheck).payload).GuessFactor;
            int resultToWeigh = 0;
            while (resultToWeigh < numResults) {
                DCHit result = (DCHit)results.get((int)resultToWeigh).payload;
                double checkGuessFactor = result.GuessFactor;
                double diff = Math.abs((guessFactor - checkGuessFactor) * oneOverBotWidthAngle);
                if (diff <= 1.0) {
                    density += result.HitWeight;
                }
                ++resultToWeigh;
            }
            if (density > bestDensity) {
                bestDensity = density;
                bestGuessFactor = guessFactor;
            }
            ++resultToCheck;
        }
        return bestGuessFactor;
    }
}

