/*
 * Decompiled with CFR 0.152.
 */
package eem.misc;

import eem.misc.math;
import java.io.IOException;
import robocode.RobocodeFileWriter;

public class logger {
    public static final int log_important = 0;
    public static final int log_error = 2;
    public static final int log_warning = 3;
    public static final int log_profiler = 11;
    public static final int log_routine = 4;
    public static final int log_debuging = 5;
    public static final int log_noise = 10;
    private static int verbosity_level = 5;
    private static RobocodeFileWriter fileWriter = null;

    public logger(int n) {
        this();
        verbosity_level = n;
    }

    public logger(int n, RobocodeFileWriter robocodeFileWriter) {
        this();
        fileWriter = robocodeFileWriter;
        verbosity_level = n;
    }

    public logger() {
    }

    public static void log_message(int n, String string) {
        if (n <= verbosity_level) {
            System.out.println(string);
        }
        if (n <= verbosity_level) {
            if (fileWriter != null) {
                try {
                    string = string + "\n";
                    fileWriter.write(string);
                    fileWriter.flush();
                }
                catch (IOException iOException) {
                    System.out.println("Trouble writing to the log file: " + iOException.getMessage());
                }
            } else {
                System.out.println("The log file writer does not exist");
            }
        }
    }

    public static void warning(String string) {
        logger.log_message(3, string);
    }

    public static void noise(String string) {
        logger.log_message(10, string);
    }

    public static void profiler(String string) {
        logger.log_message(11, string);
    }

    public static void error(String string) {
        logger.log_message(2, string);
    }

    public static void dbg(String string) {
        logger.log_message(5, string);
    }

    public static void routine(String string) {
        logger.log_message(4, string);
    }

    public static void important(String string) {
        logger.log_message(0, string);
    }

    public static String shortFormatDouble(double d) {
        String string = String.format("%.2f", d);
        return string;
    }

    public static String hitRateFormat(int n, int n2) {
        double d = math.eventRate(n, n2);
        String string = logger.shortFormatDouble(100.0 * d) + "%";
        string = String.format("%8s", string);
        String string2 = String.format("%4d", n);
        String string3 = String.format("%-4d", n2);
        String string4 = "";
        String string5 = string2 + "/" + string3 + " = " + string;
        string4 = string4 + String.format("%16s", string5);
        return string4;
    }
}

