/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import wcsv.PowerHouse.Gun.GunCoordinator;
import wcsv.PowerHouse.Movement.MoveCoordinator;
import wcsv.PowerHouse.Radar.RadarCoordinator;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PowerHouse
extends AdvancedRobot {
    private static GunCoordinator gunner = null;
    private static MoveCoordinator mover = null;
    private static RadarCoordinator radar = null;
    private static int hits = 0;
    private static int misses = 0;
    private static int wins = 0;
    private static boolean enemyHasNoPoints = true;
    private Target target;
    private Target thisRobot;
    private ScannedRobotEvent lastScan;
    private boolean noAction;

    public void run() {
        Utilities.fWidth = this.getBattleFieldWidth();
        Utilities.fHeight = this.getBattleFieldHeight();
        this.setColors(Color.blue.darker(), Color.red, Color.white);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        if (this.getRoundNum() > 0) {
            System.out.print("Win %: ");
            System.out.println((double)wins / (double)this.getRoundNum() * 100.0);
        } else {
            System.out.println("PowerHouse 1.7e3 ready.");
        }
        if (gunner == null) {
            gunner = new GunCoordinator(this);
        } else {
            gunner.reset();
        }
        if (mover == null) {
            mover = new MoveCoordinator(this);
        } else {
            mover.reset();
        }
        if (radar == null) {
            radar = new RadarCoordinator(this);
        }
        this.noAction = false;
        this.lastScan = null;
        this.target = null;
        this.thisRobot = null;
        while (true) {
            if (this.lastScan != null) {
                this.handleScan(this.lastScan);
            }
            radar.performAction(this.target);
            if (this.target != null && this.getEnergy() > 0.0) {
                if (this.getOthers() > 0) {
                    gunner.update(this.target, this.thisRobot);
                    gunner.performAction(this.target, this.thisRobot);
                    mover.update(this.target, this.thisRobot);
                }
                if (this.getOthers() > 0 || !PowerHouse.mover.waves.isEmpty()) {
                    mover.performAction(this.target, this.thisRobot);
                }
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastScan = e;
    }

    public void handleScan(ScannedRobotEvent e) {
        if (this.target == null) {
            this.target = new Target(e, this);
        } else {
            this.target.update(e, this);
        }
        if (this.thisRobot == null) {
            this.thisRobot = new Target(this, e);
        } else {
            this.thisRobot.update(this, e);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.noAction = true;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        mover.onHitByBullet(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        this.target.tempDamage -= (double)3 * e.getBullet().getPower();
        enemyHasNoPoints = false;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        mover.onBulletHitBullet(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
    }

    public void onBulletHit(BulletHitEvent e) {
        if (!this.noAction) {
            ++GunCoordinator.actualBulletHits;
        }
        this.target.tempDamage += e.getBullet().getPower() * (double)4;
        if (e.getBullet().getPower() > 1.0) {
            this.target.tempDamage += (e.getBullet().getPower() - 1.0) * (double)2;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        if (!this.noAction) {
            ++GunCoordinator.actualBulletMisses;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("Skipped Turn");
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit Wall");
    }

    public void onWin(WinEvent e) {
        this.roundOver();
        ++wins;
    }

    public void roundOver() {
    }

    public void onPaint(Graphics2D g) {
        Wave w = PowerHouse.mover.wave;
    }

    private final /* synthetic */ void this() {
        this.target = null;
        this.thisRobot = null;
        this.lastScan = null;
        this.noAction = false;
    }

    public PowerHouse() {
        this.this();
    }
}

